/*
Admin mod script. Copyright (C) 2000, Alfred Reynolds.

 Parts by: them@clanwho.com (http://www.clanwho.com) (admin_rcon)
 Other parts by: Nathan O'Sullivan (numtostr and admin_vote_restart)
 	         Jaguar  <magua@wedgewood.net>  (new script functions)
*/

// Use the new DLL functions
#define USE_CUSTOM_DLL 0

#include <core>
#include <console>
#include <admin>
#include <adminhelper>

/* Some settings for the script */

// Should we check for Modelcheater?
#define ENABLE_ANTI_MODEL_CHEAT 1

// pause in seconds between invisibility cheater warnings
#define INVIS_WARN_PAUSE 480

// Minimum pause between any two warnings
#define WARN_PAUSE 60

// Time that the warning message appears 
#define WARN_TIME 30



#define ALL 0
#define LEV1 1
#define LEV2 1<<1
#define LEV4  1<<2
#define LEV8 1<<3
#define LEV16 1<<4
#define LEV32 1<<5 //32
#define LEV64 1<<6 // 64
#define LEV128 1<<7
#define LEV256 1<<8
#define LEV512 1<<9
#define LEV1024 1<<10
#define LEV2048  1<< 11
#define LEV4096  1<<12
#define LEV8192 1<<13
#define LEV16384 1<<14
#define LEV32768 1<<15

#define ACCESS_VARIABLE LEV256

enum PRINT_TYPE {
	print_console=0,
        print_center,
        print_chat
  };

#define INVIS_INVALID -1
#define USER_INVALID -1

/* The setting of MAX_ITEMS depends upon how busy the server is; twice your max player limit
should do fine, but for a busy server, you might want to make it triple or quadruple. */
#define MAX_ITEMS 36
#define MAX_NAME_LENGTH 50
#define MAX_DATA_LENGTH 200
#define MAX_TEXT_LENGTH 200
#define MAX_NUMBER_LENGTH 10

/* Global variables */
new user[50]; // the username of the person calling the script
new Users[MAX_ITEMS]; /* 1 dimensional array - WON ID or Session ID */
new UserInvisTime[MAX_ITEMS]; /* Used to determine the number of seconds left until a new warning is displayed for the same user */
new lastWarning = 0;
new skipWarning = 0;

/*****************************************************************************
			HELPER FUNCTIONS
******************************************************************************/



/* returns 1 if two strings are EXACTLY the same in the first n (or less if one is smaller than n) digits, 0 otherwise */

streq(a[],b[],n) {
	
 	new i;
	
	// be careful about how much we check
	if (n > strlen(a)) n=strlen(a);
	if (n > strlen(b)) n=strlen(b);

	for(i=0;i<n;i++) 
		if (a[i]!=b[i]) return 0;

	return 1;
}

/* copy the first n chars of b to a */
strncpy(a[],b[],n) {

	new i;
	
	for(i=0;i<n;i++) 
		a[i]=b[i];
//	a[i]=0;

	return 1;
}

min(a,b) {
	if (a<b) return a;
	else return b;
	return 1;
}


/* put b on the end of a for a max of n chars*/
strncat(a[],b[],n) {

	new i=0;
	new j;
	new amount;

	while(a[i]!=0 && i<strlen(a) && i<n) i++;

	amount=min(n-i,strlen(b));

	for(j=0;j<amount;j++)
		a[i+j]=b[j]; 
//	a[i+j]=0;
}


// FROM Nathan O'Sullivan
/* NumToStr courtesy of Nathan O'Sullivan (http://nathan.qgl.org/halflifeadmin/numtostr.txt) */
public numtostr(num,str[])
{
	new Base = 1;
	new Digits = 1;
	new i = 0;
	
	/* Special case: 0 */
	if (num == 0) {
		str[i] = '0';
		str[i+1] = NULL_CHAR;
	} else {
		/* If we've got a negative number, add a negative sign
		to the string, and multiply the number by -1 */
		if (num < 0) {
			str[i++] = '-';	
			num *= -1;
		}
	
		/* Ok.  We've got at least one digit.  Keep multiplying by
		10 till we get a higher number than what we've got.  Note 
		that this will leave Digits 1 higher than what we want (eg,
		if Num was 7, Digits will be 2 */
		while (Base <= num) {
			Base *= 10;
			Digits++;
		}
		
		/* Because Digits is higher, use --Digits rather than Digits--. 
		Also, divide Base before using it. */
		while (--Digits > 0) {
			Base /= 10;
			str[i++] = '0' + (num - (num % Base)) / Base;
			num = num % Base;
		}
		str[i++] = NULL_CHAR;
	}
}

/* Put strEnd on the end of strBegin. Note that strBegin must be large enough to handle
this; the size of strEnd doesn't matter. */
strcat(strBegin[],strEnd[]) {
	new i=0;
	new Length = strlen(strEnd);
	new j;
	while(strBegin[i]!=0) i++;
	for(j=0;j<Length;j++)
		strBegin[i+j]=strEnd[j];
	/* Null-terminate the string. */
	strBegin[i+j] = NULL_CHAR;
}


/* END */
/* Jaguars new bits */
/* Like strcat, but assumes that strEnd is large enough to handle the addition, and that
the size of strBegin doesn't matter. */
strprepend(strBegin[], strEnd[]) {
	new i;
	new BeginLength = strlen(strBegin);
	new EndLength = strlen(strEnd);
	for (i=(EndLength-1);i>=0;i--)
		strEnd[i+BeginLength]=strEnd[i];
	strEnd[BeginLength+EndLength] = NULL_CHAR;
	for (i=0;i<BeginLength;i++)
		strEnd[i] = strBegin[i];
}

/* returns 1 if two strings are the same in the first Length (or less 
if one is smaller than Length) digits, 0 otherwise */
strmatch(strOne[],strTwo[],Length) {
	new i;
	if (Length > strlen(strTwo)) Length=strlen(strTwo);
	for(i=0;i<Length;i++)
		if (tolower(strOne[i])!=tolower(strTwo[i])) return 0;
	return 1;
}



/*****************************************************************************
			END OF HELPER FUNCTIONS
******************************************************************************/

/* Like AddUserIndex, but won't create a new entry if one doesn't exist...will simply return USER_INVALID. */
public GetUserIndex(UserID) {
	new UserCount = 0;
	new UserIndex = USER_INVALID;
	
	/*  Find our user within the list of previous adds.*/
	for(UserCount=0;UserCount<MAX_ITEMS;UserCount++) {
		/* Check to see if the user at the ucrrent index is the one we want. */
		if(UserID==Users[UserCount]) {
			UserIndex = UserCount;
			break;
		}
	}
	return UserIndex;
}

/* Given a user name, returns the index associated with the user.  Returns USER_INVALID if no
new index can be created.  This should never happen, though. */
public AddUserIndex(UserID) {
	new Text[MAX_TEXT_LENGTH];
	new UserCount = 0;
	new UserIndex = GetUserIndex(UserID);
	
	if (UserIndex == USER_INVALID) {
		for (UserCount=0; UserCount<MAX_ITEMS; UserCount++) {
			if (Users[UserCount]==0) {
				UserIndex = UserCount;
				Users[UserIndex] = UserID;
#if ENABLE_ANTI_MODEL_CHEAT==1
				UserInvisTime[UserIndex] = INVIS_INVALID;
#endif
				break;
			}
		}
	}
	if (UserIndex==USER_INVALID) {
		strncpy(Text, "WARNING: Could not add user index!",MAX_TEXT_LENGTH);
		say(Text);
	}
	return UserIndex;
}			


/* Resets the data to newly initialized states. */
public ResetData() {
	new i;
	for(i=0;i<MAX_ITEMS;i++) {
#if ENABLE_ANTI_MODEL_CHEAT==1
		UserInvisTime[i] = INVIS_INVALID;
#endif
		Users[i] = 0;
	}
	lastWarning = 0;
}


/* Initialize serverinfo table via defaults from server.cfg */
public InitData() {
  
  new numstr[7] = {0, ...};
  new value[40];
  new retval = 0;
  new configFile[10] = "admin.cfg";

  /* enable private debug messages */
  strinit(value,40);
  retval = get_serverinfo("pdebug",value,40);
  if ( retval == 0 || strlen(value) == 0 ) {
	readfile(configFile,numstr,2,7);
	if ( retval == 0 ) {  // set 0 as default
	  numtostr(retval, numstr);
	} else {
	  numstr[strlen(numstr)-1] = 0;
	}  // if-else
	
	set_serverinfo("pdebug", numstr );
  }  // if

  new LogText[MAX_TEXT_LENGTH] = "pdebug is set to: ";
  if ( strlen(value) == 0 ) {
	strcat(LogText, numstr);
  } else {
	strcat(LogText, value);
  }  // if-else
  log(LogText);

#if ENABLE_ANTI_MODEL_CHEAT==1

  /* display invisibility model warning */
  strinit(value,40);
  retval = get_serverinfo("display_invis_warn",value,40);
  if ( retval == 0 || strlen(value) == 0 ) {
	retval = readfile(configFile,numstr,4,7);
	if ( retval == 0 ) {  // set 0 as default
	  numtostr(retval, numstr);
	} else {
	  numstr[strlen(numstr)-1] = 0;
	}  // if-else
	set_serverinfo("display_invis_warn", numstr);
  }  // if

  strinit(LogText, MAX_TEXT_LENGTH);
  strncpy(LogText, "display_invis_warn is set to: ", strlen("display_invis_warn is set to: "));
  if ( strlen(value) == 0 ) {
	strcat(LogText, numstr);
  } else {
	strcat(LogText, value);
  }  // if-else
  log(LogText);

  /*  distance betwee any two warnings. */
  strinit(value,40);
  retval = get_serverinfo("warn_pause",value,40);
  if ( retval == 0 || strlen(value) == 0 ) {
	retval = readfile(configFile,numstr,6,7);
	if (retval == 0) { // set a default
	  retval = WARN_PAUSE;
	  numtostr(retval,numstr);
	}  else {
	  numstr[strlen(numstr)-1] = 0;
	}  // if-else
	set_serverinfo("warn_pause", numstr);
  }  // if

  strinit(LogText, MAX_TEXT_LENGTH);
  strncpy(LogText, "warn_pause is set to: ", strlen("warn_pause is set to: "));
  if ( strlen(value) == 0 ) {
	strcat(LogText, numstr);
  } else {
	strcat(LogText, value);
  }  // if-else
  log(LogText);

  /* distance between two invisibility warnings from the same user */
  strinit(value,40);
  retval = get_serverinfo("invis_warn_pause",value,40);
  if ( retval == 0 || strlen(value) == 0 ) {
	retval = readfile(configFile,numstr,8,7);
	if ( retval == 0 ) { // set a default
	  retval = INVIS_WARN_PAUSE;
	  numtostr(retval,numstr);
	}   else {
	  numstr[strlen(numstr)-1] = 0;
	} // if-else
	set_serverinfo("invis_warn_pause", numstr);
  }  // if

  strinit(LogText, MAX_TEXT_LENGTH);
  strncpy(LogText, "invis_warn_pause is set to: ", strlen("invis_warn_pause is set to: "));
  if ( strlen(value) == 0 ) {
	strcat(LogText, numstr);
  } else {
	strcat(LogText, value);
  }  // if-else
  log(LogText);

  /* time a warning is displayed */
  strinit(value,40);
  retval = get_serverinfo("warn_time",value,40);
  if ( retval == 0 || strlen(value) == 0 ) {
	retval = readfile(configFile,numstr,10,7);
	if ( retval == 0 ) {  // set a default
	  retval = WARN_TIME;
	  numtostr(retval,numstr);
	} else {
	  numstr[strlen(numstr)-1] = 0;
	}  // if-else
	set_serverinfo("warn_time", numstr);
  }  // if

  strinit(LogText,MAX_TEXT_LENGTH);
  strncpy(LogText, "warn_time is set to: ", strlen("warn_time is set to: "));
  if ( strlen(value) == 0 ) {
	strcat(LogText, numstr);
  } else {
	strcat(LogText, value);
  }  // if-else
  log(LogText);


#endif
}

/*****************************************************************************
			ADMIN FUNCTIONS
******************************************************************************/


admin_enable(key[]) {

  if ( auth("") != 1 || access(ACCESS_VARIABLE,"")!=1) {
	message(user,"You don't have access to this command");
	return;
  }  // if
                                    
  set_serverinfo(key, "1");
}

admin_disable(key[]) {

  if ( auth("") != 1 || access(ACCESS_VARIABLE,"")!=1) {
	message(user,"You don't have access to this command");
	return;
  }  // if
                                    
  set_serverinfo(key,"0");
}


admin_set(para[]) {

  if ( auth("") != 1 || access(ACCESS_VARIABLE,"")!=1) {
	message(user,"You don't have access to this command");
	return;
  }  // if
                                    
  new key[40] = {0, ...};
  new value[40] = {0, ...};

  strbreak(para, key, value, 40);
  if ( strlen(key) != 0 && strlen(value) != 0 ) {
	set_serverinfo(key, value);
  }  // if
}


admin_var(para[]) {

  if ( auth("") != 1 || access(ACCESS_VARIABLE,"")!=1) {
	message(user,"You don't have access to this command");
	return;
  }  // if
                                    
  new value[40] = {0, ...};
  
  if (strlen(para) == 0) {
	return;
  }

  get_serverinfo(para,value,40);

  new LogText[100] = {0, ...};

  strncpy(LogText, para, strlen(para));
  strcat(LogText, " is set to <");
  strcat(LogText, value);
  strcat(LogText, ">");
  log(LogText);
  message(user,LogText);
}



admin_say(msg[]) {

	new pmsg[100];

	if ( auth("") != 1 || access(LEV64,"")!=1) {
		message(user,"You don't have access to this command");
		return;
	}                                    

 	strncpy(pmsg, "Message from Admin ( ", strlen("Message from Admin ( "));
        strncat(pmsg, user,100);
        strncat(pmsg, " ) ",100);
        say(pmsg);
        say(msg);
}

admin_map(map[]) {

	if ( auth("") != 1 || access(LEV2,"")!=1) {
		message(user,"You don't have access to this command");
		return;	
	}

	if (valid_map(map)==1) {
		say("Changing level to :");
		say(map);
		changelevel(map);
	} else {
		message(user,"Bad map name");
		message(user,map);
	}
}





admin_vote_kick(kick_user[]) {

	if ( access(LEV1,"")!=1) {
		message(user,"You don't have access to this command");	
		return;	
	}

	if (vote_allowed()!=1) {
		message(user, "Vote not allowed at this time.");
		return;
	}
	if (check_user(kick_user) == 1) {
		new real_user[MAX_NAME_LENGTH];
		get_username(kick_user,real_user,MAX_NAME_LENGTH);
		//SayCommand();
		new msg[MAX_DATA_LENGTH] = "Kick ";
		strcat(msg,real_user);
		strcat(msg,"?");
		vote(msg,"Yes","No","kick_vote",real_user);
	} else {
		message(user,"Unrecognized user name ");
		message(user,kick_user);
	}

	

}


public kick_vote(a,b,c,d) {
 
	new vote_kick_username[100];
	convert_string(b,vote_kick_username,100);

 	if ( a == 1 ) {
		new ratio = getvar("kick_ratio");
		if ( ratio == 0 ) {
			say("Kick vote is not enabled");
			return;
		}
		if ( c > (ratio/100)*d ) {
			new rc;
	        	rc=check_user(vote_kick_username);
			if( rc>0 ) { 
    			new real_user[32];
   			if ( rc == 2 || rc == 3 ) {
         			get_username( vote_kick_username, real_user,32);
    			} else {
            			strncpy(real_user ,vote_kick_username,32);
    			}

			new msg[200];			
	
			strncpy(msg,real_user,32);
			strncat(msg," kicked due to vote",200-strlen(real_user));
			say(msg);
			message(real_user,"You have been kicked due to a vote");
			kick(real_user);
			}
 		} else {
			say("Not enough votes for kick");
		}
	} else {
		say("Not enough votes for kick");
	}
}


admin_vote_map(map[]) {

	if ( vote_allowed()==1 && access(LEV1,"")==1) {
			if ( valid_map(map) == 1) {
				new msg[100];
				if (strlen(map)<1) {
					message(user,"Incorrect commandline");
				}

				strncpy(msg,"Change map to ",strlen("Change map to "));
				strcat(msg,map);
				log(msg);
				vote(msg,"Yes","No","map_vote",map);
			} else
				message(user,"Map does not exist");
		} else 
			message(user,"Vote not allowed at this time");

}


public map_vote(a,b,c,d) {
 
	new vote_map[100];
	new tell[500];
	convert_string(b,vote_map,100);
	
 	if ( a == 1 ) {
		new ratio = getvar("map_ratio");
		if ( ratio == 0 ) {
			say("Map vote is not enabled");
			return;
		}
		if ( c > (ratio/100)*d ) {
			strncpy(tell,"Change of map to ",strlen("Change of map to "));
			strncat(tell,vote_map,500);
			strncat(tell," due to vote",500);
			centersay(tell,10,0,255,0);
			changelevel(vote_map);
		} else {
			say("Not enough votes for map change");	
		}
	} else {
		say("Not enough votes for map change");
	}
}


// FROM Nathan O'Sullivan
/*
 *****
 admin_vote_restart

 To use, add the following in client_commands():

  else if (streq(command,"admin_vote_restart",strlen(command))==1)
                admin_vote_restart(data);

 Requires: numtostr()
 *****
*/

admin_vote_restart(unused[]) {
        if ( vote_allowed()==1 && access(LEV1,"")==1) {
                new msg[100];
                strncpy(msg,"Restart map & begin play?",strlen("Restart map & begin play?") );
                vote(msg,"Yes","No","restart_vote",unused);
        } else
                message(user,"Vote not allowed at this time");
}

public restart_vote(a,b,c,d) {

        new vote_map[100];
        convert_string(b,vote_map,100);

        if ( a == 1 ) {
                new ratio = getvar("map_ratio");
                if ( ratio == 0 ) {
                        say("Restart vote is not enabled");
                        return;
                }
                if ( c > (ratio/100)*d ) {
                        new tleft, tlimit;
                        tleft = timeleft() - 10; // # seconds till restart!
                        tlimit = getvar("mp_timelimit");
                        tlimit = tlimit + (tlimit - tleft/60);

                        new str[100],tmp[50];
                        strncpy(str,"mp_timelimit ",50);
                        numtostr(tlimit,tmp);
                        strncat(str,tmp,50);
                        exec (str);
                        exec ("sv_restartround 10");
                } else {
                        say("Not enough votes for map restart");
                }
        } else {
                say("Not enough votes for map restart");
        }
}


/* END */



admin_gravity(a[]) {

	if ( auth("") != 1 || access(LEV32,"")!=1) {
		message(user,"You don't have access to this command");	
		return;	
	}

	new msg[100];
	strncpy(msg,"sv_gravity ",strlen("sv_gravity "));
	strcat(msg,a);
	say("Changing gravity to:");
	say(a);
	exec(msg);
}

admin_pause(a) {

	if ( auth("") != 1 || access(LEV8,"")!=1) {
		message(user,"You don't have access to this command");	
		return;	
	}

 
	new msg[100];
	strncpy(msg,"pausable ",strlen("pausable "));

	if ( a == 1) {
		strcat(msg," 1");
		log("setting pausable to 1");
	} else {
		strcat(msg," 0");
		log("setting pausable to 0");
	}

	exec(msg);

}

admin_pass(a[]) {

	if ( auth("") != 1 || access(LEV16,"")!=1) {
		message(user,"You don't have access to this command");
		return;	
	}
 
	new msg[100];
	strncpy(msg,"sv_password ",strlen("sv_password "));
	strcat(msg,a);
	a[strlen(a)-1]=0;
	log("setting password");

	exec(msg);

}

admin_friendlyfire(a[]) {

	if ( auth("") != 1 || access(LEV32,"")!=1) {
		message(user,"You don't have access to this command");
		return;	
	}
 
	new msg[100];
	strncpy(msg,"mp_friendlyfire ",strlen("mp_friendlyfire "));
	strcat(msg,a);
	log("setting mp_friendlyfire");

	exec(msg);

}

admin_teamplay(a[]) {

	if ( auth("") != 1 || access(LEV32,"")!=1) {
		message(user,"You don't have access to this command");	
		return;	
	}
 
	new msg[100];
	strncpy(msg,"mp_teamplay ",strlen("mp_teamplay "));
	strcat(msg,a);
	log("setting mp_teamplay");

	exec(msg);

}

admin_fraglimit(a[]) {

	if ( auth("") != 1 || access(LEV2,"")!=1) {
		message(user,"You don't have access to this command");
		return;	
	}
 
	new msg[100];
	strncpy(msg,"mp_fraglimit ",strlen("mp_fraglimit "));
	strcat(msg,a);
	log("setting mp_fraglimit");

	exec(msg);

}

admin_timelimit(a[]) {

	if ( auth("") != 1 || access(LEV2,"")!=1) {
		message(user,"You don't have access to this command");
		return;	
	}	
 
	new msg[100];
	strncpy(msg,"mp_timelimit ",strlen("mp_timelimit "));
	strcat(msg,a);
	log("setting mp_timelimit");

	exec(msg);

}

admin_kick(kick_user[]) {

	if ( auth("") != 1 || access(LEV128,"")!=1) {
		message(user,"You don't have access to this command");
		return;	
	}

	if ( check_user(kick_user) == 1) {
		new real_user[MAX_NAME_LENGTH];
		get_username(kick_user,real_user,MAX_NAME_LENGTH);
		//SayCommand();
		message(real_user,"You have been kicked by ");
		message(real_user,user);
		kick(real_user);
	} else {
		message(user,"Unrecognized player: ");
		message(user,kick_user);
	}

}

admin_cfg(a[]) {

	if ( auth("") != 1 || access(LEV512,"")!=1) {
		message(user,"You don't have access to this command");
		return;	
	}
 
	new msg[100];
	strncpy(msg,"exec ",strlen("exec "));
	strcat(msg,a);
	log("Executing script");

	exec(msg);
}

admin_restartround(a[]) {

	if ( auth("") != 1 || access(LEV4,"")!=1) {
		message(user,"You don't have access to this command");
		return;	
	}
 
	new msg[100];
	strncpy(msg,"sv_restartround ",strlen("sv_restartround "));
	strcat(msg,a);
	log("setting sv_restartround");

	exec(msg);

}


admin_prematch(a[]) {

	if ( auth("") != 1 || access(LEV4,"")!=1) {
		message(user,"You don't have access to this command");
		return;	
	}
 
	new msg[100];
	strncpy(msg,"tfc_clanbattle_prematch ",strlen("tfc_clanbattle_prematch "));
	strcat(msg,a);
	log("setting tfc_clanbattle_prematch");

	exec(msg);

}

admin_unban(a[]) {

	if ( auth("") != 1 || access(LEV256,"")!=1) {
		message(user,"You don't have access to this command");
		return;	
	}
 
	unban(a);
	log("Unbanning user:");
	log(a);
}

admin_ban(ban_user[]) {

	if ( auth("") != 1 || access(LEV256,"")!=1) {
		message(user,"You don't have access to this command");
		return;	
	}
 
	if (check_user(ban_user)==1) {
		new real_user[MAX_NAME_LENGTH];
		get_username(ban_user,real_user,MAX_NAME_LENGTH);
		//LogCommand();
		ban(real_user,0);
	} else {
		message(user, "Unrecognized player: ");
		message(user, ban_user);
	}

}

admin_reload() {

	if ( auth("") != 1 || access(LEV4,"")!=1) {
		message(user,"You don't have access to this command");
		return;	
	}
	reload();
}






admin_rcon(a[]) {

        new tellout[500];
        if ( auth("") != 1 || access(LEV512,"") != 1) {
                message(user,"Access to this command is not allowed");
                return;
        }


	if ( streq(a, "rcon_password", strlen("rcon_password")) || streq(a, "RCON_PASSWORD", strlen("RCON_PASSWORD"))) {
                message(user, "Denied, command logged and red flagged for review");
                strncpy(tellout, "WARNING: ", strlen("WARNING: "));
                strcat(tellout, user);
                strcat(tellout, " has attempted to change the rcon_password, BANNING");
                ban(user, 0);
                kick(user);
                return;
        }
        strncpy(tellout, "ADMIN COMMAND: ", strlen("ADMIN COMMAND: "));
        strncat(tellout, user,500);
        strncat(tellout, " just issued an rcon command.",500);
        say(tellout);
        exec(a);
}


admin_listmaps(user_here[]) {
	new curmap[100];

	message(user_here,"The maps on the mapcycle are:");
	list_maps();
	message(user_here,"and the current map is:");
	currentmap(curmap,100);
	message(user_here,curmap);



}

public say_stuff() {
centersay("This server is using Admin Mod",10,0,255,0);
}


/*
 *
 * Called when the server first loads up a level (when the first client connects)
 *
 */


public client_start() { 
	set_timer("say_stuff",600,99999); // repeat forever	
	ResetData();
	InitData();
}


new new_user[40];

public say_hello() {
	messageex(new_user,"Welcome to the Real World...",print_center);
}


#if ENABLE_ANTI_MODEL_CHEAT==1
#define TMPSTR_LENGTH 20

/* Check a model to be a invisibility cheat */

check_invis_model(model[]) {

  if ( istrstr(model,"arcticoranget")>=0 ) {
	if ( is_enabled("pdebug") ) {
	  log("DEBUG aot matched");
	}  // if
	return 1;
  }  // if
  if ( istrstr(model,"arcticorange")>=0 ) {
	if ( is_enabled("pdebug") ) {
	  log("DEBUG  ao matched");
	}  // if
	return 1;
  }  // if
  if ( istrstr(model,"oranget")>=0 ) {
	if ( is_enabled("pdebug") ) {
	  log("DEBUG  ot matched");
	}  // if
	return 1;
  }  // if
  if ( istrstr(model,"orange")>=0 ) {
	if ( is_enabled("pdebug") ) {
	  log("DEBUG   o matched");
	}  // if
	return 1;
  }  // if
  
  return 0;
} 

#endif

/*
 *
 *
 * Called when a clients info details change (like their name,model,...)
 *   type "setinfo" into the client console to get a full list
 *
 */

public client_info(HLname,HLSessionID,HLWONID) {
	new name[40],model[40];

	convert_string(HLname,name,40); // the username 
	
	get_userinfo(name,"model",model,40); // get the model the user has

	//set_serverinfo("ALFRED","this is what I store");
	//message(name,model); // now tell them what it is ;)
	//message(name,"user details changed :)");

#if ENABLE_ANTI_MODEL_CHEAT==1

  new Text[MAX_TEXT_LENGTH] = "Security notice: User ";
  
  new LogText[MAX_TEXT_LENGTH] = "Security notice: User ";
  
  new LogDebug[MAX_TEXT_LENGTH];
  
  new UserID = 0;
  new UserIndex = USER_INVALID;
  new TellOnUser = 0;
  new tmpstr[TMPSTR_LENGTH];
  

#if USE_CUSTOM_DLL==1
  new TimeLeft = maptime(1,0);
#else
  new TimeLeft = timeleft();
#endif

  new IsCheatModel = 0;
  
  if ( lastWarning && ((lastWarning - TimeLeft) < get_serverinfo_int("warn_pause")) ) {
	  IsCheatModel = 0;

	  if ( is_enabled("pdebug") ) {
		log("DEBUG Warning pause");
	  }  // if

  } else {

	if ( is_enabled("pdebug") ) {
	  strinit(LogDebug,MAX_TEXT_LENGTH);
	  strncpy(LogDebug,"DEBUG checking model ",strlen("DEBUG checking model "));
	  strcat(LogDebug,model);
	  log(LogDebug);
	}  // if

	IsCheatModel = check_invis_model(model);
  }  // if-else
  
  if ( getvar("sv_lan") ) {  // vor a LAN session we index by the session ID
	UserID = HLSessionID;
  } else {                   // else we index by the WON ID
	UserID = HLWONID;
  }  // if-else
  
  if ( (IsCheatModel == 1) && (skipWarning == 0) ) {  // we disable warnings for users connecting
	                                                  // in order to prevent preliminary warnings
	//if ( (IsCheatModel == 1)  ) {                     
	
	/* don't warn on users that do not exist yet */
	if (UserID == 0) {
	  UserIndex = USER_INVALID;
	  TellOnUser = 0;

	  if ( is_enabled("pdebug") ) {
		log("DEBUG No checking for ID 0");
	  }  // if

	} else {
	  UserIndex = AddUserIndex(UserID);   // insert the cheating user in the cheaters array
	}  // if-else

	if ( (UserIndex != USER_INVALID) ) {   // we added the user successfully
	  if ( (UserInvisTime[UserIndex] == INVIS_INVALID) ) {  // this is the first time for this user
		TellOnUser = 1;  // we'll tell the world!

		if ( is_enabled("pdebug") ) {
		  log("DEBUG First time for user");
		}  // if

	  } else {   // we issued a warning for this user before
		new TimeDiff = UserInvisTime[UserIndex] - TimeLeft;
		if ( TimeDiff > get_serverinfo_int("invis_warn_pause") ) {

		  if ( is_enabled("pdebug") ) {
			log("DEBUG Repeated warning for user");
		  }  // if

		  TellOnUser = 1;
		} else {

		  if ( is_enabled("pdebug") ) {
			log("DEBUG Not Ready for new warning for this user");
		  }  // if

		  TellOnUser = 0;
		}  // if-else
	  }  // if-else
	}  // if
	
	if ( TellOnUser == 1 ) {  // we will issue a warning
	  lastWarning = TimeLeft; // set the time of the last warning to now
	  UserInvisTime[UserIndex] = lastWarning;

	  if ( is_enabled("display_invis_warn") ) {  // if we should display warnings
		strcat(Text,"^n");
		strcat(Text, name);
		strcat(Text,"^nmight be using an invisibility cheat!");
		centersay(Text,get_serverinfo_int("warn_time"),255,5,0);
	  }  // if

	  //-- log the warning in the log file
	  strcat(LogText, name);
	  strcat(LogText," might be using an invisibility cheat!");
	  log(LogText);
	  strinit(LogText,MAX_TEXT_LENGTH);
	  strncpy(LogText,"Cheater WonID: ",strlen("Cheater WonID: "));
	  numtostr(UserID,tmpstr);
	  strcat(LogText,tmpstr);
	  strcat(LogText," Reason: ");
	  strcat(LogText,model);
	  log(LogText);

	} else {

	  if ( is_enabled("pdebug") ) {
		log("DEBUG Dont tell on user");
	  }  // if

	}  // if-else

  } else {

	if ( is_enabled("pdebug") ) {
	  strinit(LogDebug,MAX_TEXT_LENGTH);
	  numtostr(IsCheatModel,tmpstr);
	  strncpy(LogDebug,"DEBUG IsCheatModel: '",strlen("DEBUG IsCheatModel: '"));
	  strcat(LogDebug,tmpstr);
	  strcat(LogDebug,"'  skipWarning: '");
	  numtostr(skipWarning,tmpstr);
	  strcat(LogDebug,tmpstr);
	  log(LogDebug);
	}  // if

  }  // if-else
  
#endif
}




#if ENABLE_ANTI_MODEL_CHEAT==1

public unskip_warning() {
  skipWarning = 0;

  if ( is_enabled("pdebug") ) {
	log("DEBUG Warning unskipped");
  }  // if

}
#endif

/*
 *
 * Called when each player joins the server
 *
 */

public client_connect(a,b) {
	new name[40],ip[200];
	// NOTE - you cannot message this user as they don't exists yet (really ...) 
	// You can set a timer to message them in 30 sec or so tho
	// DOUBLE NOTE - the timer here won't work right when more than 1 person enters in a 30 sec period. An array would have to be made, but you bright scripters can do that :)



	convert_string(a,name,40); // the username
	convert_string(b,ip,40); // the ip of the user
	strncpy(new_user,name,40);

	set_timer("say_hello",30,0); // say hello to the user


#if ENABLE_ANTI_MODEL_CHEAT==1
	if ( skipWarning == 0 ) {
	  skipWarning = 1;
	  
	  if ( is_enabled("pdebug") ) {
		log("DEBUG skipping warnings");
	  }  // if
	  
	  set_timer("unskip_warning",28,0);
	}  // if
#endif
}




/*
 *
 * Main function called when a client enters a command into the console
 *
 */
public client_commands(HLCommand,HLData,HLUser,HLSessionID,HLWONID) {

	new command[40],data[100];

	convert_string(HLCommand,command,40);
        convert_string(HLData,data,100);
        convert_string(HLUser,user,40);

  		
	// check_words needs to be above he strlen check
	if ( check_words(data)==0) {
		message(user,"You are not allowed to swear on this server");
		return 1;
	}

	//new tst[100];
	//get_serverinfo("ALFRED",tst,100);     // get the value stored in ALFRED
	//log(tst);

	if ( strlen(command) < strlen("admin") ) return 0;

	if( streq(command,"admin_say",strlen(command))==1 ) 
	  admin_say(data);
	else if( streq(command,"admin_map",strlen(command))==1) 
	  admin_map(data);
	else if( streq(command,"admin_vote_kick",strlen(command))==1) 
	  admin_vote_kick(data);
	else if( streq(command,"admin_vote_map",strlen(command))==1) 
	  admin_vote_map(data);
	else if( streq(command,"admin_vote_restart",strlen(command))==1) 
	  admin_vote_restart(data);
	else if( streq(command,"admin_gravity",strlen(command))==1)
	  admin_gravity(data);
	else if( streq(command,"admin_pause",strlen(command))==1)
	  admin_pause(1);
	else if( streq(command,"admin_unpause",strlen(command))==1)
	  admin_pause(0);
	else if( streq(command,"admin_pass",strlen(command))==1)
	  admin_pass(data);
	else if( streq(command,"admin_nopass",strlen(command))==1)
	  admin_pass("^"^"");
	else if( streq(command,"admin_friendlyfire",strlen(command))==1) 
	  admin_friendlyfire(data);
	else if( streq(command,"admin_fraglimit",strlen(command))==1)
	  admin_fraglimit(data);
	else if( streq(command,"admin_teamplay",strlen(command))==1) 
	  admin_teamplay(data);
	else if( streq(command,"admin_timelimit",strlen(command))==1) 
	  admin_timelimit(data);
	else if( streq(command,"admin_kick",strlen(command))==1) 
	  admin_kick(data);
	else if( streq(command,"admin_cfg",strlen(command))==1) 
	  admin_cfg(data);
	else if( streq(command,"admin_prematch",strlen(command))==1) 
	  admin_prematch(data);
	else if( streq(command,"admin_restartround",strlen(command))==1) 
	  admin_restartround(data);
	else if( streq(command,"admin_unban",strlen(command))==1) 
	  admin_unban(data);
	else if( streq(command,"admin_ban",strlen(command))==1) 
	  admin_ban(data);
	else if( streq(command,"admin_reload",strlen(command))==1) 
	  admin_reload();
	else if( streq(command,"admin_timeleft",strlen(command))==1) 
	  timeleft();
 	else if( streq(command,"admin_nextmap",strlen(command))==1) 
	  nextmap(data,0);
	else if( streq(command,"admin_version",strlen(command))==1)
	  version();
	else if( streq(command,"admin_userlist",strlen(command))==1)
	  userlist();
	else if( streq(command,"admin_help",strlen(command)) ==1)
	  help(data);
	else if( streq(command,"admin_rcon",strlen(command))==1 )
	  admin_rcon(data);
	else if( streq(command,"admin_listmaps",strlen(command))==1 )
	  admin_listmaps(user);
	else if( streq(command,"admin_enable",strlen(command))==1 )
	  admin_enable(data);
	else if( streq(command,"admin_disable",strlen(command))==1 )
	  admin_disable(data);
	else if( streq(command,"admin_set",strlen(command))==1 )
	  admin_set(data);
	else if( streq(command,"admin_var",strlen(command))==1 )
	  admin_var(data);
	

	// return 1 to say we got a command and acted upon it
	if ( streq(command,"admin_",strlen("admin_")) ==1) 
		return 1;
	
	return 0;
}

