#include <core>
#include <console>
#include <admin>

/* Credits:

Alfred: For making Admin mod, of course.
[WHO]Them (Them@ClanWHO.com): Wrote the basis on which the map voting system was built, 
	and came up with the idea of admin_execall 

*/

/* Compiler Definitions - Set as appropriate. 1 to enable, 0 to disable. Don't
forget to recompile. */

/* Note: When you compile this admin.sma, you'll get warnings that say
'symbol is never used'.  These types of warnings can be ignored. */

/* Use the new DLL functions from a custom DLL
   DON'T enable this unless you know exactly what you are doing! */
#define USE_CUSTOM_DLL 0

#include <jaghelper>

/* Do you want the server to respond to certain chat commands (like 'nextmap',
'timeleft', etc?) Note that this is required to use the hlds_ld style map 
vote, below */
#define ENABLE_CHAT_COMMANDS 1

/* Do you want to enable the admin_execclient command?  Note that this is 
different from enabling execclient in the DLL...admin_slay, for instance, uses 
execclient in the DLL, but does not use the admin_execclient command.  
Disabling this would just prevent people from using admin_execclient command, 
but doesn't stop the script from calling execclient.

Note that to use any execclient at all, you have to have

allow_client_exec 1 

in your server.cfg */
#define ENABLE_EXECCLIENT 1

/* Do you want gagging to block people from using say_team, as well as just normal say? */
#define ENABLE_GAG_SAYTEAM 1

/* Do you want a hlds_ld style map vote (where you say 'vote <map>' to vote)
to come up before the end of the map?  Note that ENABLE_CHAT_COMMANDS, above,
must also be set to 1 for this to be effective. */
#define ENABLE_HLDSLD_MAP_VOTE 1

/* This is for my special stuff which likely isn't going to become part of the admin mod
distribution...those just plain odd things that I put in.  Unless you get my DLL from me,
you can't compile if you set this to 1, so I recommend leaving it at 0. =P */
#define ENABLE_JAGUAR_STUFF 0

/* I admit, I don't see the point of using Admin Mod to give someone rcon 
access.  Just give them the rcon_password. But if you want to enable 
admin_rcon, set this to 1. */
#define ENABLE_RCON 1

/* Enabling admin_vote_any may be a security hole, as it allows execution of
arbitrary rcon commands (except for rcon_password).  Therefore, turn it off
if you don't want it. */
#define ENABLE_VOTE_ANY 0

/* I don't use swear word checking, but if you do, set this to 1. */
#define ENABLE_WORD_CHECK 1

/* Set this to 1 to stop the three 'symbol is never used' warnings that I know about
from appearing. */
#define HIDE_KNOWN_WARNINGS 1

/* If INDEX_BY_WONID is 1, then the user indexes will be done by WON ID.  
Pretty obvious, huh? =) If this isn't 1, then the user indexes will be done 
by session ID.  Useful for LAN games (where everyone has the same WON ID),
but means that gagged people can just disconnect and reconnect, etc.  In
addition, it increases the risk that the arrays will go out of bounds; this 
can be lessened by increasing MAX_ITEMS, below. */
#define INDEX_BY_WONID 1

// Should we check for Modelcheater?
#define ENABLE_ANTI_MODEL_CHEAT 1

// Abstand in secons between Cheater warnings
#define INVIS_WARN_PAUSE 480

// Minimum pause between any two warnings
#define WARN_PAUSE 60

// Time that the warning message appears 
#define WARN_TIME 30


/* Constants / definitions */

#define ACCESS_HELP 0
#define ACCESS_TIMELEFT 0
#define ACCESS_USERLIST 0
#define ACCESS_VERSION 0
#define ACCESS_VOTE_KICK 1
#define ACCESS_VOTE_MAP 1
#define ACCESS_FRAGLIMIT 2
#define ACCESS_MAP 2
#define ACCESS_RESTART 2
#define ACCESS_TIMELIMIT 2
#define ACCESS_PREMATCH 4
#define ACCESS_RELOAD 4
#define ACCESS_PAUSE 8
#define ACCESS_PASS 16
#define ACCESS_TEAMPLAY 32
#define ACCESS_CHAT 64
#define ACCESS_SAY 64
#define ACCESS_KICK 128
#define ACCESS_SLAY 128
#define ACCESS_BAN 256
#define ACCESS_VARIABLE 256
#define ACCESS_CONFIG 512
#define ACCESS_STATUS 512
#define ACCESS_GRAVITY 1024
#define ACCESS_GAG 2048
#define ACCESS_IMMUNITY 4096
#define ACCESS_TELEPORT 8192
#define ACCESS_RESERVE_NICK 16384 /* This is never used in the script; just for reference */
#define ACCESS_RESERVE_SPOT 32768 /* This is never used in the script; just for reference */

#if ENABLE_VOTE_ANY==1
#define ACCESS_VOTE_ANY 1
#endif

#if ENABLE_JAGUAR_STUFF==1
#define ACCESS_SLAP 128
#endif

#if ENABLE_EXECCLIENT==1
#define ACCESS_EXECCLIENT 8192
#endif

#if ENABLE_RCON==1
#define ACCESS_RCON 65536
#endif

/* The setting of MAX_ITEMS depends upon how busy the server is; twice your max player limit
should do fine, but for a busy server, you might want to make it triple or quadruple. */
#define MAX_ITEMS 32
#define MAX_COMMAND_LENGTH 30
#define MAX_DATA_LENGTH 200
#define MAX_NAME_LENGTH 50
#define MAX_NUMBER_LENGTH 10
#define MAX_TEXT_LENGTH 200

#define GAG_INVALID -1
#define MAP_INVALID -1
#define USER_INVALID -1
#define VOTE_INVALID -1
#define INVIS_INVALID -1

#define CHAR_INVALID -1
#define TRUE 1
#define FALSE 0

/* Forward declarations */
DebugMessage(Text[]);
NumToStr(num,str[]);
strbreak(str[],first[],second[], maxlen);
strcat(strBegin[], strEnd[]);
strcount(str[], searchchar);
strinit(str[],Length);
strncpy(strTo[],strFrom[],Length);
strprepend(strBegin[], strEnd[]);
strstripquotes(str[]);
GetMapIndex(MapName[]);
GetUserIndex(UserID);
LogCommand();
ProcessVote(UserID,MapName[]);
SayCommand();
SayCurrentMap();
SayNextMap();
SayTimeleft();
SayWinningMap();
StartMapVote();

/* Enumerations */
#if ENABLE_HLDSLD_MAP_VOTE==1
enum VoteStatus {
	VoteInProgress,		/* Voting is allowed */
	VoteNotBegun,		/* Voting not allowed - no vote in progress, but a vote may be called */
	MapStart,			/* Voting not allowed - map just began */
	VoteFinished		/* Voting not allowed - vote just finished */
}
#endif

/* enum PRINT_TYPE {
    print_console,
    print_center,
    print_chat,
} */
#define print_console 0
#define print_center 1
#define print_chat 2

/* String data */
new NULL_CHAR = '^0';
new PERIOD_CHAR = '.';
new QUOTE_CHAR = '^"';

new STRING_DENIED[] = "You do not have access to this command."; /* Generic message to show people who can't use a command */
new STRING_VERSION[] = "Version 0.9.6 (11/14/2000)"; /* Version of the script */
new STRING_DEBUG_USER[] = "Jaguar"; /* User to show debug messages to */

#if ENABLE_HLDSLD_MAP_VOTE==1
new MAP_EXTEND[] = "extend"; /* Key word to use to extend map during map vote */
#endif

/* Global variables */
new Debug = 0;
#if ENABLE_HLDSLD_MAP_VOTE==1
new VoteStatus:MapVoteStatus = MapStart;
new WinningMapIndex = MAP_INVALID;
#endif

new NewMap[MAX_NAME_LENGTH];

#if ENABLE_HLDSLD_MAP_VOTE==1
new Maps[MAX_ITEMS][MAX_NAME_LENGTH]; /* 2 dimensional array - Map Index / Map Name */
new MapVotes[MAX_ITEMS]; /* Number of votes for this map */
#endif

new Users[MAX_ITEMS]; /* 1 dimensional array - WON ID or Session ID as determined by INDEX_BY_WONID */
#if ENABLE_HLDSLD_MAP_VOTE==1
new UserVotes[MAX_ITEMS]; /* Index of the map user voted for, VOTE_INVALID for none */
#endif
new UserGagTime[MAX_ITEMS]; /* The number of seconds left until the user can speak, GAG_INVALID if the user isn't gagged */
#if ENABLE_ANTI_MODEL_CHEAT==1
new UserInvisTime[MAX_ITEMS]; /* The number of seconds left until the user can speak, GAG_INVALID if the user isn't gagged */
new lastWarning = 0;
new skipWarning = 0;
#endif

new user[MAX_NAME_LENGTH];
new data[MAX_DATA_LENGTH];
new command[MAX_COMMAND_LENGTH];

/*****************************************************************************
			HELPER FUNCTIONS
******************************************************************************/

/* Returns 1 if the current user has the required auth level, 0 otherwise */
public CheckAuth(AuthLevel) {
	new Result = access(AuthLevel,user);
	if (Result!=0) Result = 1;
	return Result;
}

/* Display a debugging message */
public DebugMessage(Text[]) {
	if (Debug==1) {
		strprepend("DEBUG: ", Text);
		message(STRING_DEBUG_USER, Text);
	}
}

min(a,b) {
	if (a<b) return a;
	else return b;
	return 1;
}

/* NumToStr courtesy of Nathan O'Sullivan (http://nathan.qgl.org/halflifeadmin/numtostr.txt) */
public NumToStr(num,str[])
{
	new Base = 1;
	new Digits = 1;
	new i = 0;
	
	/* Special case: 0 */
	if (num == 0) {
		str[i++] = '0';
		str[i++] = NULL_CHAR;
	} else {
		/* If we've got a negative number, add a negative sign
		to the string, and multiply the number by -1 */
		if (num < 0) {
			str[i++] = '-';	
			num *= -1;
		}
	
		/* Ok.  We've got at least one digit.  Keep multiplying by
		10 till we get a higher number than what we've got.  Note 
		that this will leave Digits 1 higher than what we want (eg,
		if Num was 7, Digits will be 2 */
		while (Base <= num) {
			Base *= 10;
			Digits++;
		}
		
		/* Because Digits is higher, use --Digits rather than Digits--. 
		Also, divide Base before using it. */
		while (--Digits > 0) {
			Base /= 10;
			str[i++] = '0' + (num - (num % Base)) / Base;
			num = num % Base;
		}
		str[i++] = NULL_CHAR;
	}
}

/* Given a string (str[]), this will attempt to break it apart at the first 
space that's not inside quotation marks.  Quotes at the beginning and end
will be stripped.  Ie,

new str[20] = "This is a test"
new first[20];
new second[20];
strbreak(str,first,second, 20);

first is now equal to "This", and second is now equal to "is a test".  If 
str[] had been "^"This is^" a test", first would be "This is" and second would 
be "a test" */
strbreak(str[], first[], second[], maxlen) {
	new i = 0;
	new NullPos = CHAR_INVALID;
	new Quote = FALSE;
	new SpacePos = CHAR_INVALID;

	if (maxlen == 0)
		maxlen = strlen(str);
			
	for(i=0; i<maxlen; i++) {
		if (str[i] == QUOTE_CHAR) {
			if (Quote==FALSE) {
				Quote = TRUE;
			} else {
				Quote = FALSE;
			}
		} else if (str[i] == ' ' && SpacePos == CHAR_INVALID && Quote == FALSE) {
			SpacePos = i;
		} else if (str[i] == NULL_CHAR) {
			NullPos = i;
			break;
		}	
	}
	
	if (SpacePos == CHAR_INVALID) {
		strncpy(first, str, maxlen);
		strinit(second, maxlen);
	} else {
		if (NullPos == CHAR_INVALID)
			NullPos = maxlen + 1;
			
		for(i=0; i<SpacePos; i++) 
			first[i] = str[i];
		first[SpacePos] = NULL_CHAR;
		
		for(i=SpacePos+1; i<NullPos;i++)
			second[i - SpacePos - 1] = str[i];
		second[NullPos - SpacePos - 1] = NULL_CHAR;
	}
	
	/* Strip out the quotes of the return values. */
	strstripquotes(first);
	strstripquotes(second);
}

/* Put strEnd on the end of strBegin. Note that strBegin must be large enough to handle
this; the size of strEnd doesn't matter. */
strcat(strBegin[],strEnd[]) {
	new i=0;
	new Length = strlen(strEnd);
	new j;
	while(strBegin[i]!=0) i++;
	for(j=0;j<Length;j++)
		strBegin[i+j]=strEnd[j];
	/* Null-terminate the string. */
	strBegin[i+j] = NULL_CHAR;
}

/* Counts the number of times searchchar appears in str[] */
strcount(str[], searchchar) {
	new i = 0;
	new maxlen = strlen(str);
	new Count = 0;
	
	for(i = 0; i <= maxlen; i++) {
		if (str[i] == searchchar)
			Count++;
	}
	return Count;
}

/* Like strcat, but assumes that strEnd is large enough to handle the addition, and that
the size of strBegin doesn't matter. */
strprepend(strBegin[], strEnd[]) {
	new i;
	new BeginLength = strlen(strBegin);
	new EndLength = strlen(strEnd);
	for (i=(EndLength-1);i>=0;i--)
		strEnd[i+BeginLength]=strEnd[i];
	strEnd[BeginLength+EndLength] = NULL_CHAR;
	for (i=0;i<BeginLength;i++)
		strEnd[i] = strBegin[i];
}

/* returns 1 if two strings are the same in the first Length (or less 
if one is smaller than Length) digits, 0 otherwise */
strmatch(strOne[],strTwo[],Length) {
	new i;
	if (Length > strlen(strTwo)) Length=strlen(strTwo);
	for(i=0;i<Length;i++)
		if (tolower(strOne[i])!=tolower(strTwo[i])) return 0;
	return 1;
}

/* Returns 1 if two strings are exactly the same, including length, etc */
streq(strOne[],strTwo[]) {
	if (strlen(strOne)!=strlen(strTwo)) return 0;
	new i=strmatch(strOne,strTwo,strlen(strOne));
	return i;
}
	

/* Initialize a string */
strinit(str[],Length) {
	new i;
	for(i=0;i<Length;i++)
		str[i] = NULL_CHAR;
}

/* copy the first 'Length' chars of strFrom to strTo */
strncpy(strTo[],strFrom[],Length) {
	new i;
	if (Length > strlen(strFrom)) Length = strlen(strFrom);
	for(i=0;i<Length;i++)
		strTo[i]=strFrom[i];
	if (Length == strlen(strFrom)) strTo[Length] = NULL_CHAR;
	return 1;
}

/* Strips the quotes from the beginning and ending, if they exist. Ignores
those in the middle. */
strstripquotes(str[]) {
	new maxlen = strlen(str);
	new i;
	
	if(maxlen==0)
		return;
		
	if(str[maxlen - 1]==QUOTE_CHAR) 
		str[--maxlen] = NULL_CHAR;
		
	if(str[0] == QUOTE_CHAR) {
		for(i=0; i<=maxlen; i++)
			str[i] = str[i+1];
		str[i-2] = NULL_CHAR;
	}
}

/*****************************************************************************
			DATA FUNCTIONS
******************************************************************************/

/* Nicely formats the current command */
public FormatCommand(Text[]) {
	strprepend("ADMIN Command: ", Text);
	strcat(Text, user);
	strcat(Text, " used command ");
	strcat(Text, command);
	strcat(Text, " ");
	strcat(Text, data);
}

/* Given a map name, returns the index associated with the map.  Returns MAP_INVALID if no
new index can be created.  This should never happen, though. */
#if ENABLE_HLDSLD_MAP_VOTE==1
public AddMapIndex(MapName[]) {
	new Text[MAX_TEXT_LENGTH];
	new MapCount = 0;
	new MapIndex = GetMapIndex(MapName);
	
	if (MapIndex==MAP_INVALID) {
		for(MapCount=0;MapCount<MAX_ITEMS;MapCount++) {
			if(Maps[MapCount][0]==NULL_CHAR) {
				strncpy(Text,"Adding map index for ", MAX_TEXT_LENGTH);
				strcat(Text, MapName);
				DebugMessage(Text);
				MapIndex = MapCount;
				strncpy(Maps[MapIndex],MapName, MAX_NAME_LENGTH);
				MapVotes[MapIndex] = 0;
				break;
			}
		}
	}
	if (MapIndex==MAP_INVALID) {
		strncpy(Text, "WARNING: Found no map index for ", MAX_TEXT_LENGTH);
		strcat(Text, MapName);
		say(Text);
	}
	return MapIndex;
}
#endif

/* Given a user name, returns the index associated with the user.  Returns USER_INVALID if no
new index can be created.  This should never happen, though. */
public AddUserIndex(UserID) {
	new Text[MAX_TEXT_LENGTH];
	new UserCount = 0;
	new UserIndex = GetUserIndex(UserID);
	
	if (UserIndex == USER_INVALID) {
		for (UserCount=0; UserCount<MAX_ITEMS; UserCount++) {
			if (Users[UserCount]==0) {
				UserIndex = UserCount;
				Users[UserIndex] = UserID;
#if ENABLE_HLDSLD_MAP_VOTE==1
				UserVotes[UserIndex] = VOTE_INVALID;
#endif
				UserGagTime[UserIndex] = GAG_INVALID;
				break;
			}
		}
	}
	if (UserIndex==USER_INVALID) {
		strncpy(Text, "WARNING: Could not add user index!",MAX_TEXT_LENGTH);
		say(Text);
	}
	return UserIndex;
}			

/* Like AddMapIndex, but won't create a new entry if one doesn't exist...will simply return MAP_INVALID. */
#if ENABLE_HLDSLD_MAP_VOTE==1
public GetMapIndex(MapName[]) {
	new Text[MAX_TEXT_LENGTH];
	new MapCount = 0;
	new MapIndex = MAP_INVALID;
	
	/*  Find our Map within the list of previous votes.  If the Map doesn't exist, add 'em. */
	for(MapCount=0;MapCount<MAX_ITEMS;MapCount++) {
		/* Check to see if the map at the current index is the one we want. */
		if (streq(MapName, Maps[MapCount])==1) {
			strncpy(Text,"Found map index for ", MAX_TEXT_LENGTH);
			strcat(Text, MapName);
			DebugMessage(Text);
			MapIndex = MapCount;
			break;
		}
	}
	return MapIndex;
}
#endif

/* Like AddUserIndex, but won't create a new entry if one doesn't exist...will simply return USER_INVALID. */
public GetUserIndex(UserID) {
	new UserCount = 0;
	new UserIndex = USER_INVALID;
	
	/*  Find our user within the list of previous votes.  If the user doesn't exist, add 'em. */
	for(UserCount=0;UserCount<MAX_ITEMS;UserCount++) {
		/* Check to see if the user at the ucrrent index is the one we want. */
		if(UserID==Users[UserCount]) {
			UserIndex = UserCount;
			break;
		}
	}
	return UserIndex;
}

/* Resets the data to newly initialized states. */
public ResetData() {
	new i;
	for(i=0;i<MAX_ITEMS;i++) {
#if ENABLE_HLDSLD_MAP_VOTE==1
		Maps[i][0] = NULL_CHAR;
		MapVotes[i] = 0;
		UserVotes[i] = VOTE_INVALID;
#endif
		UserGagTime[i] = GAG_INVALID;
#if ENABLE_ANTI_MODEL_CHEAT==1
		UserInvisTime[i] = INVIS_INVALID;
#endif
		Users[i] = 0;
	}
}

/* Initialize serverinfo table via defaults from admin.cfg */
public InitData() {
  
  new numstr[7] = {0, ...};
  new value[40];
  new retval = 0;
  new configFile[10] = "admin.cfg";

  /* enable private debug messages */
  strinit(value,40);
  retval = get_serverinfo("pdebug",value,40);
  if ( retval == 0 || strlen(value) == 0 ) {
	readfile(configFile,numstr,2,7);
	if ( retval == 0 ) {  // set 0 as default
	  NumToStr(retval, numstr);
	} else {
	  numstr[strlen(numstr)-1] = 0;
	}  // if-else
	
	set_serverinfo("pdebug", numstr );
  }  // if

  new LogText[MAX_TEXT_LENGTH] = "pdebug is set to: ";
  if ( strlen(value) == 0 ) {
	strcat(LogText, numstr);
  } else {
	strcat(LogText, value);
  }  // if-else
  log(LogText);

#if ENABLE_ANTI_MODEL_CHEAT==1

  /* display invisibility model warning */
  strinit(value,40);
  retval = get_serverinfo("display_invis_warn",value,40);
  if ( retval == 0 || strlen(value) == 0 ) {
	retval = readfile(configFile,numstr,4,7);
	if ( retval == 0 ) {  // set 0 as default
	  NumToStr(retval, numstr);
	} else {
	  numstr[strlen(numstr)-1] = 0;
	}  // if-else
	set_serverinfo("display_invis_warn", numstr);
  }  // if

  strinit(LogText, MAX_TEXT_LENGTH);
  strncpy(LogText, "display_invis_warn is set to: ", strlen("display_invis_warn is set to: "));
  if ( strlen(value) == 0 ) {
	strcat(LogText, numstr);
  } else {
	strcat(LogText, value);
  }  // if-else
  log(LogText);

  /*  distance betwee any two warnings. */
  strinit(value,40);
  retval = get_serverinfo("warn_pause",value,40);
  if ( retval == 0 || strlen(value) == 0 ) {
	retval = readfile(configFile,numstr,6,7);
	if (retval == 0) { // set a default
	  retval = WARN_PAUSE;
	  NumToStr(retval,numstr);
	}  else {
	  numstr[strlen(numstr)-1] = 0;
	}  // if-else
	set_serverinfo("warn_pause", numstr);
  }  // if

  strinit(LogText, MAX_TEXT_LENGTH);
  strncpy(LogText, "warn_pause is set to: ", strlen("warn_pause is set to: "));
  if ( strlen(value) == 0 ) {
	strcat(LogText, numstr);
  } else {
	strcat(LogText, value);
  }  // if-else
  log(LogText);

  /* distance between two invisibility warnings from the same user */
  strinit(value,40);
  retval = get_serverinfo("invis_warn_pause",value,40);
  if ( retval == 0 || strlen(value) == 0 ) {
	retval = readfile(configFile,numstr,8,7);
	if ( retval == 0 ) { // set a default
	  retval = INVIS_WARN_PAUSE;
	  NumToStr(retval,numstr);
	}   else {
	  numstr[strlen(numstr)-1] = 0;
	} // if-else
	set_serverinfo("invis_warn_pause", numstr);
  }  // if

  strinit(LogText, MAX_TEXT_LENGTH);
  strncpy(LogText, "invis_warn_pause is set to: ", strlen("invis_warn_pause is set to: "));
  if ( strlen(value) == 0 ) {
	strcat(LogText, numstr);
  } else {
	strcat(LogText, value);
  }  // if-else
  log(LogText);

  /* time a warning is displayed */
  strinit(value,40);
  retval = get_serverinfo("warn_time",value,40);
  if ( retval == 0 || strlen(value) == 0 ) {
	retval = readfile(configFile,numstr,10,7);
	if ( retval == 0 ) {  // set a default
	  retval = WARN_TIME;
	  NumToStr(retval,numstr);
	} else {
	  numstr[strlen(numstr)-1] = 0;
	}  // if-else
	set_serverinfo("warn_time", numstr);
  }  // if

  strinit(LogText,MAX_TEXT_LENGTH);
  strncpy(LogText, "warn_time is set to: ", strlen("warn_time is set to: "));
  if ( strlen(value) == 0 ) {
	strcat(LogText, numstr);
  } else {
	strcat(LogText, value);
  }  // if-else
  log(LogText);


#endif
}

/*****************************************************************************
			CLIENT FUNCTIONS
******************************************************************************/

#if ENABLE_ANTI_MODEL_CHEAT==1

/* Check a model to be a invisibility cheat */

check_invis_model(model[]) {

  if ( istrstr(model,"arcticoranget")>=0 ) {
	if ( is_enabled("pdebug") ) {
	  log("DEBUG aot matched");
	}  // if
	return 1;
  }  // if
  if ( istrstr(model,"arcticorange")>=0 ) {
	if ( is_enabled("pdebug") ) {
	  log("DEBUG  ao matched");
	}  // if
	return 1;
  }  // if
  if ( istrstr(model,"oranget")>=0 ) {
	if ( is_enabled("pdebug") ) {
	  log("DEBUG  ot matched");
	}  // if
	return 1;
  }  // if
  if ( istrstr(model,"orange")>=0 ) {
	if ( is_enabled("pdebug") ) {
	  log("DEBUG   o matched");
	}  // if
	return 1;
  }  // if
  
  return 0;
} 

#endif

#if ENABLE_HLDSLD_MAP_VOTE==1
public AllowMapVote() {
	MapVoteStatus = VoteNotBegun;
}
#endif

public ChangeMap() {
	if(NewMap[0]!=NULL_CHAR) {
		changelevel(NewMap);
	}
}

public client_info(HLname,HLSessionID,HLWONID) {
	new name[40],model[40];
	convert_string(HLname,name,40); // the username 
	get_userinfo(name,"model",model,40); // get the model the user has
#if HIDE_KNOWN_WARNINGS==1
	min(HLSessionID, HLWONID);
#endif
#if ENABLE_ANTI_MODEL_CHEAT==1

  new Text[MAX_TEXT_LENGTH] = "Security notice: User ";
  
  new LogText[MAX_TEXT_LENGTH] = "Security notice: User ";
  
  new LogDebug[MAX_TEXT_LENGTH];
  
  new UserID = 0;
  new UserIndex = USER_INVALID;
  new TellOnUser = 0;
  new tmpstr[20];
  

#if USE_CUSTOM_DLL==1
  new TimeLeft = maptime(1,0);
#else
  new TimeLeft = timeleft();
#endif

  new IsCheatModel = 0;
  
  if ( lastWarning && ((lastWarning - TimeLeft) < get_serverinfo_int("warn_pause")) ) {
	  IsCheatModel = 0;

	  if ( is_enabled("pdebug") ) {
		log("DEBUG Warning pause");
	  }  // if

  } else {

	if ( is_enabled("pdebug") ) {
	  strinit(LogDebug,MAX_TEXT_LENGTH);
	  strncpy(LogDebug,"DEBUG checking model ",strlen("DEBUG checking model "));
	  strcat(LogDebug,model);
	  log(LogDebug);
	}  // if

	IsCheatModel = check_invis_model(model);
  }  // if-else
  
  if ( getvar("sv_lan") ) {  // vor a LAN session we index by the session ID
	UserID = HLSessionID;
  } else {                   // else we index by the WON ID
	UserID = HLWONID;
  }  // if-else
  
  if ( (IsCheatModel == 1) && (skipWarning == 0) ) {  // we disable warnings for users connecting
	                                                  // in order to prevent preliminary warnings
	//if ( (IsCheatModel == 1)  ) {                     
	
	/* don't warn on users that do not exist yet */
	if (UserID == 0) {
	  UserIndex = USER_INVALID;
	  TellOnUser = 0;

	  if ( is_enabled("pdebug") ) {
		log("DEBUG No checking for ID 0");
	  }  // if

	} else {
	  UserIndex = AddUserIndex(UserID);   // insert the cheating user in the cheaters array
	}  // if-else

	if ( (UserIndex != USER_INVALID) ) {   // we added the user successfully
	  if ( (UserInvisTime[UserIndex] == INVIS_INVALID) ) {  // this is the first time for this user
		TellOnUser = 1;  // we'll tell the world!

		if ( is_enabled("pdebug") ) {
		  log("DEBUG First time for user");
		}  // if

	  } else {   // we issued a warning for this user before
		new TimeDiff = UserInvisTime[UserIndex] - TimeLeft;
		if ( TimeDiff > get_serverinfo_int("invis_warn_pause") ) {

		  if ( is_enabled("pdebug") ) {
			log("DEBUG Repeated warning for user");
		  }  // if

		  TellOnUser = 1;
		} else {

		  if ( is_enabled("pdebug") ) {
			log("DEBUG Not Ready for new warning for this user");
		  }  // if

		  TellOnUser = 0;
		}  // if-else
	  }  // if-else
	}  // if
	
	if ( TellOnUser == 1 ) {
	  lastWarning = TimeLeft;
	  UserInvisTime[UserIndex] = lastWarning;

	  if ( is_enabled("display_invis_warn") ) {
		strcat(Text,"^n");
		strcat(Text, name);
		strcat(Text,"^nmight be using an invisibility cheat!");
		centersay(Text,get_serverinfo_int("warn_time"),255,5,0);
	  }  // if

	  strcat(LogText, name);
	  strcat(LogText," might be using an invisibility cheat!");
	  log(LogText);
	  strinit(LogText,MAX_TEXT_LENGTH);
	  strncpy(LogText,"Cheater WonID: ",strlen("Cheater WonID: "));
	  NumToStr(UserID,tmpstr);
	  strcat(LogText,tmpstr);
	  strcat(LogText," Reason: ");
	  strcat(LogText,model);
	  log(LogText);

	} else {

	  if ( is_enabled("pdebug") ) {
		log("DEBUG Dont tell on user");
	  }  // if

	}  // if-else

  } else {

	if ( is_enabled("pdebug") ) {
	  strinit(LogDebug,MAX_TEXT_LENGTH);
	  NumToStr(IsCheatModel,tmpstr);
	  strncpy(LogDebug,"DEBUG IsCheatModel: '",strlen("DEBUG IsCheatModel: '"));
	  strcat(LogDebug,tmpstr);
	  strcat(LogDebug,"'  skipWarning: '");
	  NumToStr(skipWarning,tmpstr);
	  strcat(LogDebug,tmpstr);
	  log(LogDebug);
	}  // if

  }  // if-else
  
#endif
}



#if ENABLE_ANTI_MODEL_CHEAT==1
public unskip_warning() {
  skipWarning = 0;
  if ( is_enabled("pdebug") ) {
	log("DEBUG Warning unskipped");
  }  // if
}
#endif

public client_connect(Name,IP) {
#if HIDE_KNOWN_WARNINGS==1
	new strName[MAX_NAME_LENGTH],strIP[MAX_DATA_LENGTH];
	convert_string(Name, strName,MAX_NAME_LENGTH); // the username 
	convert_string(IP,strIP,MAX_DATA_LENGTH); // the ip of the user
	min(1,2);
#endif

#if ENABLE_ANTI_MODEL_CHEAT==1
	if ( skipWarning == 0 ) {
	  skipWarning = 1;

	  if ( is_enabled("pdebug") ) {
		log("DEBUG skipping warnings");
	  }  // if

	  set_timer("unskip_warning",28,0);
	}  // if
#endif
}

/* Called when the server first loads up a level (when the first client connects */
public client_start() {
	new ExecCommand[MAX_DATA_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	
	strncpy(Text, "[Jaguar's Admin Script] ", MAX_TEXT_LENGTH);
	strcat(Text, STRING_VERSION);
	log(Text);
	log("[Jaguar's Admin Script] To change the following settings, look near the top of the .sma file.");
	
#if ENABLE_CHAT_COMMANDS==1
	log("[Jaguar's Admin Script] Chat commands are enabled.");
#else
	log("[Jaguar's Admin Script] Chat commands are disabled.");
#endif
	
#if ENABLE_EXECCLIENT==1
	log("[Jaguar's Admin Script] admin_execclient is enabled.");
#else
	log("[Jaguar's Admin Script] admin_execclient is disabled.");
#endif

#if ENABLE_GAG_SAYTEAM==1
	log("[Jaguar's Admin Script] Gagging prevents say_team usage.");
#else
	log("[Jaguar's Admin Script] Gagging does not prevent say_team usage.");
#endif
	
#if ENABLE_HLDSLD_MAP_VOTE==1
	log("[Jaguar's Admin Script] hlds_ld-style map voting is enabled.");
#if ENABLE_CHAT_COMMANDS==0
	log("[Jaguar's Admin Script] WARNING: ENABLE_HLDSLD_MAP_VOTE is 1 when ENABLE_CHAT_COMMANDS is 0!");
#endif
#else
	log("[Jaguar's Admin Script] hlds_ld-style map voting is disabled.");
#endif
	
#if ENABLE_JAGUAR_STUFF==1
	log("[Jaguar's Admin Script] Jaguar's custom stuff is enabled.");
#else
	log("[Jaguar's Admin Script] Jaguar's custom stuff is disabled.");
#endif

#if ENABLE_RCON==1
	log("[Jaguar's Admin Script] admin_rcon is enabled.");
#else
	log("[Jaguar's Admin Script] admin_rcon is disabled.");
#endif

#if ENABLE_VOTE_ANY==1
	log("[Jaguar's Admin Script] admin_vote_any is enabled.");
#else
	log("[Jaguar's Admin Script] admin_vote_any is disabled.");
#endif

#if ENABLE_WORD_CHECK==1
	log("[Jaguar's Admin Script] Swear word detection is enabled.");
#else
	log("[Jaguar's Admin Script] Swear word detection is disabled.");
#endif

#if HIDE_KNOWN_WARNINGS==1
	log("[Jaguar's Admin Script] Known warnings are hidden.");
#else
	log("[Jaguar's Admin Script] Known warnings are not hidden.");
#endif

#if INDEX_BY_WONID==1
	log("[Jaguar's Admin Script] User index is by WON ID.");
#else
	log("[Jaguar's Admin Script] User index is by Session ID.");
#endif
	
	currentmap(ExecCommand, MAX_DATA_LENGTH);
	strcat(ExecCommand, ".cfg");
	strprepend("exec ",ExecCommand);
	log(ExecCommand);
	exec(ExecCommand);
	
	ResetData();
	InitData();
	
#if ENABLE_HLDSLD_MAP_VOTE==1
	new intTimeLimit = getvar("mp_timelimit") * 60;
	new intTime = timeleft();

	if (intTime > (intTimeLimit - 600)) { /* If the map is not yet ten minutes in, disable voting until it is */
		MapVoteStatus = MapStart;
		set_timer("AllowMapVote",intTime - (intTimeLimit - 600), 1);
	} else {
		MapVoteStatus = VoteNotBegun;
	}
	if (intTime > 300) {
		set_timer("StartMapVote", intTime - 300, 1); /* Call for a vote five minutes before map ends */
	}
#endif
}

#if ENABLE_HLDSLD_MAP_VOTE==1
public EndMapVote() {
	new Text[MAX_TEXT_LENGTH] = "Voting is now over.  ";
	if (WinningMapIndex==MAP_INVALID) {
		strcat(Text, "No map got enough votes to win.");
		say(Text);
	} else if (streq(Maps[WinningMapIndex],MAP_EXTEND)==1) {
		strcat(Text, "The map will be extended for 30 minutes.");
		say(Text);
		set_timer("ExtendMap",2,1);
	} else {
		strcat(Text, "Changing map to ");
		strcat(Text, Maps[WinningMapIndex]);
		strncpy(NewMap, Maps[WinningMapIndex], MAX_NAME_LENGTH);
		say(Text);
		exec("mp_timelimit 1");
		set_timer("ChangeMap",2,1);
	}
	MapVoteStatus = VoteFinished;
}
#endif

#if ENABLE_HLDSLD_MAP_VOTE==1
public ExtendMap() {
	new ExecCommand[MAX_DATA_LENGTH] = "mp_timelimit ";
	new Timelimit = 0;
	new strTimelimit[MAX_NUMBER_LENGTH];
	Timelimit = getvar("mp_timelimit");
	Timelimit = Timelimit + 30;
	NumToStr(Timelimit,strTimelimit);
	strcat(ExecCommand, strTimelimit);
	exec(ExecCommand);
	set_timer("AllowMapVote",600,1); /* Allow for a new map vote 10 minutes from now */
	set_timer("StartMapVote",1620,1); /* Call for a new map vote 27 minutes from now */
}
#endif

public ExecuteCommand(Cmd[], CmdData[]) {
	new RconCmd[MAX_DATA_LENGTH];
	
	SayCommand();
	strncpy(RconCmd,Cmd,strlen(Cmd));
	strcat(RconCmd, " ");
	strcat(RconCmd, CmdData);
	exec(RconCmd);
}

/* Logs a command */
public LogCommand() {
	new Text[MAX_TEXT_LENGTH];
	FormatCommand(Text);
	log(Text);
}

/* Says a command publicly */
public SayCommand() {
	new Text[MAX_TEXT_LENGTH];
	FormatCommand(Text);
	say(Text);
}

#if ENABLE_VOTE_ANY==1
public HandleAnyVote(WinningOption,HLData,VoteCount,UserCount) {
	new ScriptData[MAX_DATA_LENGTH];
	new Text[MAX_TEXT_LENGTH] = "Vote for ";
	new strNumber[MAX_NUMBER_LENGTH];
	new Ratio = 50;
	convert_string(HLData,ScriptData,MAX_DATA_LENGTH);
	
	strcat(Text,ScriptData);
	if (WinningOption==1) {
		strcat(Text," got ");
		NumToStr(VoteCount,strNumber);
		strcat(Text,strNumber);
		strcat(Text," / ");
		NumToStr(UserCount,strNumber);
		strcat(Text,strNumber);	
		strcat(Text," (needed ");
		NumToStr(Ratio*UserCount/100,strNumber);
		strcat(Text,strNumber);
		strcat(Text,")");
		if (VoteCount >= Ratio*UserCount/100) {
			strcat(Text," -- Vote Successful.");
			say(Text);
			exec(ScriptData);
		} else {
			strcat(Text," -- Vote Not Successful.");
			say(Text);
		}
	} else {
		strcat(Text, " failed -- Vote Not Successful.");
		say(Text);
	}
}
#endif
	
/* Handle a kick vote's results. */
public HandleKickVote(WinningOption,HLUser,VoteCount,UserCount) {
	new strNumber[MAX_NUMBER_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new VoteUser[MAX_DATA_LENGTH];
	convert_string(HLUser,VoteUser,MAX_DATA_LENGTH);
	
	if (WinningOption == 1) {
		new Ratio = getvar("kick_ratio");
		if (VoteCount >= Ratio*UserCount/100) {
			say(VoteUser);
			say(" kicked due to vote.");
			message(VoteUser,"You have been kicked due to a vote.");
			kick(VoteUser);
		} else {
			strncpy(Text, "Kick vote succeeded, but not enough votes for kick (needed ", MAX_TEXT_LENGTH);
			NumToStr(Ratio*UserCount/100,strNumber);
			strcat(Text,strNumber);
			strcat(Text,")");
			say(Text);
		}
	} else {
		say("Kick vote failed.");
	}
}

/* Handle a map vote's results. */
public HandleMapVote(WinningOption,HLMap,VoteCount,UserCount) {
	new strNumber[MAX_NUMBER_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new VoteMap[MAX_DATA_LENGTH];
	convert_string(HLMap,VoteMap,MAX_DATA_LENGTH);
	
	if (WinningOption == 1) {
		new Ratio = getvar("map_ratio");
		if (VoteCount >= Ratio*UserCount/100) {
			say("Changing map to ");
			say(VoteMap);
			say("due to vote.");
			strncpy(NewMap,VoteMap,MAX_NAME_LENGTH);
			exec("mp_timelimit 1");
			set_timer("ChangeMap",2,1);
		} else {
			strncpy(Text, "Map vote succeeded, but not enough votes for change (needed ", MAX_TEXT_LENGTH);
			NumToStr(Ratio*UserCount/100,strNumber);
			strcat(Text,strNumber);
			strcat(Text,")");
			say(Text);
		}
	} else {
		say("Map vote failed.");
	}
}

public HandleSay(UserID, Speech[]) {
	if (streq(Speech, "timeleft")==1) {
		SayTimeleft();
	} else if (streq(Speech, "version")==1) {
		say(STRING_VERSION);
#if ENABLE_HLDSLD_MAP_VOTE==1
	} else if (streq(Speech, "rockthevote")==1 || streq(Speech,"mapvote")==1) {
		if (MapVoteStatus==VoteInProgress) {
			say("A map vote is already in progress.");
		} else if (MapVoteStatus==VoteNotBegun || CheckAuth(ACCESS_MAP)==1) {
			StartMapVote();
		} else if (MapVoteStatus==MapStart) {
			say("A map vote is not allowed within ten minutes of the map start.");
		} else if (MapVoteStatus==VoteFinished) {
			say("A map vote is not allowed within ten minutes of a previous vote.");
		} else {
			say("Oops.  Apparently, there's an unhandled map vote status here.");
		}
#endif
	} else if (streq(Speech, "nextmap")==1) {
		SayNextMap();
	} else if (streq(Speech, "currentmap")==1) {
		SayCurrentMap();
#if ENABLE_HLDSLD_MAP_VOTE==1
	} else if(strmatch(Speech,"vote ",MAX_DATA_LENGTH)==1) {
		if(MapVoteStatus!=VoteInProgress) {
			say("There is no map vote in progress.");
			return 0;
		}
		
		new i;
		new Length = strlen(Speech);
		new map[MAX_DATA_LENGTH];
		new Text[MAX_TEXT_LENGTH];
		
		/* we need to strip out 'vote ' (5 characters */
		for(i=5;i<Length+1;i++)
			map[i-5] = Speech[i];
		map[i-5] = NULL_CHAR;
		
		if(streq(map,MAP_EXTEND)==1) {
			ProcessVote(UserID,map);
			SayWinningMap();
		} else if(valid_map(map)==1) {
			ProcessVote(UserID, map);
			SayWinningMap();
		} else {
			strncpy(Text, "Invalid vote for map ", MAX_TEXT_LENGTH);
			strcat(Text, map);
			DebugMessage(Text);
			strinit(Text, MAX_TEXT_LENGTH);
			strncpy(Text, "Sorry, ", MAX_TEXT_LENGTH);
			strcat(Text, user);
			strcat(Text, ", ");
			strcat(Text, map);
			strcat(Text, " was not found on this server");
			say(Text);
		}
#endif
	}
	return 0;
}

/* Given a user and a map, processes the vote.  This includes subtracting a previous vote, if
the user had already made one. */
#if ENABLE_HLDSLD_MAP_VOTE==1
public ProcessVote(UserID,MapName[]) {
	new Text[MAX_TEXT_LENGTH];
	new MapIndex = 0;
	new UserIndex = 0;    

	UserIndex = AddUserIndex(UserID);
	if (UserIndex == USER_INVALID) {
		strncpy(Text, "Oops. Could not find an index for a player.  This is bad.", MAX_TEXT_LENGTH);
		say(Text);
		return;
	}
	MapIndex = AddMapIndex(MapName);
	if (MapIndex == MAP_INVALID) {
		strncpy(Text, "Oops. Could not find an index for ", MAX_TEXT_LENGTH);
		strcat(Text, MapName);
		say(Text);
		return;
	}
	if (UserVotes[UserIndex] != VOTE_INVALID) {
		strncpy(Text, "Removing previous vote for ", MAX_TEXT_LENGTH);
		strcat(Text, Maps[UserVotes[UserIndex]]);
		say(Text);
		MapVotes[UserVotes[UserIndex]] = MapVotes[UserVotes[UserIndex]] - 1;
	}
	UserVotes[UserIndex] = MapIndex;
	MapVotes[MapIndex] = MapVotes[MapIndex] + 1;
	
	new VoteCount[MAX_NUMBER_LENGTH];
	NumToStr(MapVotes[MapIndex], VoteCount);
	
	strinit(Text, MAX_TEXT_LENGTH);

	strncpy(Text,"Vote by ", MAX_TEXT_LENGTH);
	strcat(Text,user);
	strcat(Text," -- ");

	if (streq(Maps[MapIndex],MAP_EXTEND)==1)
		strcat(Text, "Extend for 30 minutes");
	else
		strcat(Text, Maps[MapIndex]);
	strcat(Text, " now has ");
	strcat(Text, VoteCount);
	if (MapVotes[MapIndex]==1)
		strcat(Text, " vote");
	else
		strcat(Text, " votes");
	say(Text);
}
#endif

public SayCurrentMap() {
	new Text[MAX_TEXT_LENGTH];
	new CurrentMap[MAX_NAME_LENGTH];
	currentmap(CurrentMap,MAX_NAME_LENGTH);
	strncpy(Text,"The current map is: ", MAX_TEXT_LENGTH);
	strcat(Text,CurrentMap);
	say(Text);
}

public SayNextMap() {
	new Text[MAX_TEXT_LENGTH];
	new NextMap[MAX_NAME_LENGTH];
	nextmap(NextMap,MAX_NAME_LENGTH);
	strncpy(Text,"The next map will be: ",MAX_TEXT_LENGTH);
	strcat(Text,NextMap);
	say(Text);
}

public SayTimeleft() {
	new Text[MAX_TEXT_LENGTH] = "Time remaining on map: ";
	new Seconds = timeleft();
	new strSeconds[MAX_NUMBER_LENGTH];
	
	Seconds /= 60;
	NumToStr(Seconds, strSeconds);
	
	strcat(Text, strSeconds);
	strcat(Text, " minutes");
	say(Text);
}

/* Give the map with the highest number of votes so far */
#if ENABLE_HLDSLD_MAP_VOTE==1
public SayWinningMap() {
		new VoteCount[MAX_NUMBER_LENGTH];
		new MapCount = 0;
		new MaxVotes = 0;
		
		WinningMapIndex = MAP_INVALID;
		for(MapCount=0;MapCount<MAX_ITEMS;MapCount++) {
			if(MapVotes[MapCount] > MaxVotes) {
				WinningMapIndex = MapCount;
				MaxVotes = MapVotes[MapCount];
			}
		}
		if(WinningMapIndex!=MAP_INVALID) {
			new Text[MAX_TEXT_LENGTH];
			if(streq(Maps[WinningMapIndex],MAP_EXTEND)==1) {
				strncpy(Text, "Extend for 30 minutes is winning", MAX_TEXT_LENGTH);
			} else {
				strncpy(Text, "Winning map so far is ", MAX_TEXT_LENGTH);
				strcat(Text, Maps[WinningMapIndex]);
			}
			NumToStr(MaxVotes, VoteCount);
			strcat(Text, " with ");
			strcat(Text, VoteCount);
			if (MaxVotes==1)
				strcat(Text, " vote");
			else
				strcat(Text, " votes");
			say(Text);
		}
}
#endif

#if ENABLE_HLDSLD_MAP_VOTE==1
public StartMapVote() {
	ResetData();
	say("Map voting has been enabled for 3 minutes.  Say 'vote <mapname>' to vote.");
	say("Say 'vote extend' to keep playing this map for 30 more minutes.");
	MapVoteStatus = VoteInProgress;
	set_timer("EndMapVote",180,1);
}
#endif

/*****************************************************************************
			ADMIN FUNCTIONS 
******************************************************************************/

admin_enable(key[]) {

  if (CheckAuth(ACCESS_VARIABLE)==0) {
	message(user,STRING_DENIED);
	return;
  }  // if

  set_serverinfo(key, "1");
}

admin_disable(key[]) {

  if (CheckAuth(ACCESS_VARIABLE)==0) {
	message(user,STRING_DENIED);
	return;
  }  // if
                                    
  set_serverinfo(key,"0");
}


admin_set(para[]) {

  if (CheckAuth(ACCESS_VARIABLE)==0) {
	message(user,STRING_DENIED);
	return;
  }  // if
                                    
  new key[40] = {0, ...};
  new value[40] = {0, ...};

  strbreak(para, key, value, 40);
  if ( strlen(key) != 0 && strlen(value) != 0 ) {
	set_serverinfo(key, value);
  }  // if
}


admin_var(para[]) {
  
  if (CheckAuth(ACCESS_VARIABLE)==0) {
	message(user,STRING_DENIED);
	return;
  }  // if

                                    
  new value[40] = {0, ...};
  
  if (strlen(para) == 0) {
	return;
  }

  get_serverinfo(para,value,40);

  new LogText[100] = {0, ...};

  strncpy(LogText, para, strlen(para));
  strcat(LogText, " is set to >");
  strcat(LogText, value);
  strcat(LogText, "<");
  log(LogText);
  message(user,LogText);
}

admin_ban(ban_data[]) {
	new ban_user[MAX_DATA_LENGTH];
	new BanTime = 0;
	new Cmd[MAX_DATA_LENGTH];
	new strTime[MAX_NUMBER_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new TargetName[MAX_NAME_LENGTH];
	
	if (CheckAuth(ACCESS_BAN)==0) {
		message(user,STRING_DENIED);
		return;
	}
	
	strbreak(ban_data,ban_user,strTime, MAX_DATA_LENGTH);
	if(strTime[0] != NULL_CHAR)
		BanTime = strtonum(strTime);
	
	if(strlen(ban_user)>=7 && strlen(ban_user)<=15 && strcount(ban_user, PERIOD_CHAR)==3) {
		SayCommand();
		message(user, "Name recognized as IP address.");
		strncpy(Cmd,"addip ", MAX_DATA_LENGTH);
		strcat(Cmd,strTime);
		strcat(Cmd," ");
		strcat(Cmd,ban_user);
		exec(Cmd);
		
		if (BanTime==0)
			exec("writeip");
	} else if (check_user(ban_user)==1) {
		get_username(ban_user,TargetName,MAX_NAME_LENGTH);
		SayCommand();
		if(access(ACCESS_IMMUNITY, TargetName)!=0) {
			strncpy(Text, "Laf.  You can't ban ", MAX_TEXT_LENGTH);
			strcat(Text,TargetName);
			strcat(Text, ", you silly bear.");
			say(Text);
		} else {
			ban(ban_user,BanTime);
		}
	} else {
		message(user, "Unrecognized player: ");
		message(user, ban_user);
	}
}

admin_chat(msg[]) {
	new i;
	new maxplayers = maxplayercount();
	new Name[MAX_NAME_LENGTH];
	new SessionID;
	new WONID;
	
	if (CheckAuth(ACCESS_CHAT)==0) {
		message(user,STRING_DENIED);
		return;
	}

	new Text[MAX_TEXT_LENGTH] = "(Admin) ";    
	strcat(Text, user);
	strcat(Text, ": ");
	strcat(Text, msg);
	for(i=1; i<=maxplayers; i++) {
		SessionID = 0;
		strinit(Name,MAX_NAME_LENGTH);
		if(playerinfo(i,Name,MAX_NAME_LENGTH,SessionID,WONID)==1) {
			if(SessionID!=0) {				
				if(strlen(Name) > 0 && access(ACCESS_CHAT,Name)!=0) {
					messageex(Name, Text, print_chat);
				}
			}
		}
	}
}

admin_cfg(Exec[]) {
	if (CheckAuth(ACCESS_CONFIG)==0) {
		message(user,STRING_DENIED);
		return;
	}
	ExecuteCommand("exec",Exec);
}

admin_csay(msg[]) {
	if (CheckAuth(ACCESS_SAY)==0) {
		message(user,STRING_DENIED);
		return;
	}
	centersay(msg,10,255,0,0);
	centersay(msg,10,0,255,0);
	LogCommand();
}

admin_debug(SetDebug) {
	if(SetDebug==1) {
		message(user,"Debugging enabled");
		strncpy(STRING_DEBUG_USER,user,MAX_NAME_LENGTH);
		Debug = 1;
	} else {
		message(user,"Debugging disabled");
		Debug = 0;
	}
}	

admin_fraglimit(FragLimit[]) {
	if (CheckAuth(ACCESS_FRAGLIMIT)==0) {
		message(user,STRING_DENIED);
		return;
	}
	ExecuteCommand("mp_fraglimit",FragLimit);
}

admin_gag(gag_user[]) {
	new Text[MAX_TEXT_LENGTH];
	new TargetName[MAX_NAME_LENGTH];
	new UserID = 0;

	if (CheckAuth(ACCESS_GAG)==0) {
		message(user,STRING_DENIED);
		return;
	}
	if (check_user(gag_user)==1) {
		get_username(gag_user,TargetName,MAX_NAME_LENGTH);
#if INDEX_BY_WONID==1
		get_userWONID(gag_user, UserID);
#else
		get_userSessionID(gag_user, UserID);
#endif
		SayCommand();
		if(access(ACCESS_IMMUNITY, TargetName)!=0) {
			strncpy(Text, "Laf.  You can't gag ", MAX_TEXT_LENGTH);
			strcat(Text,TargetName);
			strcat(Text, ", you silly bear.");
			say(Text);
		} else {
			new UserIndex = AddUserIndex(UserID);
			UserGagTime[UserIndex] = 1;
		}
	} else {
		message(user, "Unrecognized player: ");
		message(user, gag_user);
	}
}

admin_gravity(Gravity[]) {
	if (CheckAuth(ACCESS_GRAVITY)==0) {
		message(user,STRING_DENIED);
		return;
	}
	ExecuteCommand("sv_gravity",Gravity);
}

admin_kick(kick_user[]) {
	new Text[MAX_TEXT_LENGTH];
	new TargetName[MAX_NAME_LENGTH];
	
	if (CheckAuth(ACCESS_KICK)==0) {
		message(user,STRING_DENIED);
		return;
	}
	if ( check_user(kick_user) == 1) {
		get_username(kick_user,TargetName,MAX_NAME_LENGTH);
		SayCommand();
		if(access(ACCESS_IMMUNITY, TargetName)!=0) {
			strncpy(Text, "Laf.  You can't kick ", MAX_TEXT_LENGTH);
			strcat(Text,TargetName);
			strcat(Text, ", you silly bear.");
			say(Text);
		} else {				
			message(TargetName,"You have been kicked by ");
			message(TargetName,user);
			kick(kick_user);
		}
	} else {
		message(user,"Unrecognized player: ");
		message(user,kick_user);
	}
}

/* Usage:

admin_execclient <player> <cmd>

<player> = Player.  May be name, WON ID, Session ID, etc.
<cmd> = Command, just as if it was executed from the player's console.  
	Only standard hl cmds are valid.  See admin_slay for another example.

Ex,

admin_execclient jaguar kill
admin_execclient jaguar say "I am but a puppet."

*/
#if ENABLE_EXECCLIENT==1
admin_execclient(cmddata[]) {
	new Target[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new Cmd[MAX_DATA_LENGTH];
	
	if (CheckAuth(ACCESS_EXECCLIENT)==0) {
		message(user,STRING_DENIED);
		return;
	}

	strbreak(cmddata, Target, Cmd, MAX_TEXT_LENGTH);
	if (Cmd[0] == NULL_CHAR) {
		message(user, "Unparsable format: no command found.");
		return;
	}

	if(check_user(Target)==0) {
		message(user, "Unrecognized player: ");
		message(user, Target);
		return;
	}
	
	if (execclient(Target,Cmd)==0) {
		message(user, "Failed.");
	} else {
		strncpy(Text, "ADMIN Command: ", MAX_TEXT_LENGTH);
		strcat(Text, user);
		strcat(Text, " used command admin_execclient ");
		strcat(Text, Target);
		say(Text);
		if(access(ACCESS_IMMUNITY, Target)!=0) {
			strncpy(Text, "Laf.  You can't control ", MAX_TEXT_LENGTH);
			strcat(Text,Target);
			strcat(Text, ", you silly bear.");
			say(Text);
		} else {
			message(user, "Succeeded.");
		}
	}
	LogCommand();
}
#endif

#if ENABLE_EXECCLIENT==1
admin_execall(cmddata[]) {
	new i;
	new maxplayers = maxplayercount();
	new SessionID;
	new Target[MAX_NAME_LENGTH];
	new WONID;
	
	if (CheckAuth(ACCESS_EXECCLIENT)==0) {
		message(user,STRING_DENIED);
		return;
	}
	
	for(i=1; i<=maxplayers; i++) {
		strinit(Target,MAX_NAME_LENGTH);
		SessionID = 0;
		if(playerinfo(i,Target,MAX_NAME_LENGTH,SessionID,WONID)==1) {
			if(SessionID!=0) {
				if(access(ACCESS_IMMUNITY,Target)==0) {
					execclient(Target,cmddata);
				}
			}
		}
	}
	SayCommand();
}
#endif

admin_listmaps() {
	new strMap[MAX_NAME_LENGTH];

	message(user,"The maps on the mapcycle are:");
	list_maps();
	message(user,"and the current map is:");
	currentmap(strMap,MAX_NAME_LENGTH);
	message(user,strMap);
}

admin_map(map[]) {
	if (CheckAuth(ACCESS_MAP)==0) {
		message(user,STRING_DENIED);
		return;
	}
	if (valid_map(map)==1) {
		SayCommand();
		strncpy(NewMap,map,MAX_NAME_LENGTH);
		exec("mp_timelimit 1");
		set_timer("ChangeMap",2,1);
	} else {
		message(user,"Unrecognized map name ");
		message(user,map);
	}
}

admin_pass(Password[]) {
	new Text[MAX_TEXT_LENGTH];
	
	if (CheckAuth(ACCESS_PASS)==0) {
		message(user,STRING_DENIED);
		return;	
	}
	/* Don't use ExecuteCommand here, unless you want your password to
	be publicly broadcast... instead we use our own message */
	strncpy(Text, "ADMIN Command: ", MAX_TEXT_LENGTH);
	strcat(Text, user);
	strcat(Text, " has ");
	if (streq(Password,"^"^"")) {
		strcat(Text, "removed the server's password.");
	} else {
		strcat(Text, "set the server's password.");
	}
	say(Text);

	LogCommand();
	new msg[MAX_DATA_LENGTH] = "sv_password ";
	strcat(msg,Password);
	exec(msg);
}

admin_pause(Pausable) {
	if (CheckAuth(ACCESS_PAUSE)==0) {
		message(user,STRING_DENIED);	
		return;	
	}
	if(Pausable==1)
		ExecuteCommand("pausable","1");
	else
		ExecuteCommand("pausable","0");
}

admin_playercount() {
	new Count;
	new Text[MAX_TEXT_LENGTH];
	new strNum[MAX_NUMBER_LENGTH];
	
	Count = playercount();
	if(Count==1)
		strncpy(Text,"There is one player.", MAX_TEXT_LENGTH);
	else {
		strncpy(Text, "There are ", MAX_TEXT_LENGTH);
		NumToStr(Count,strNum);
		strcat(Text,strNum);
		strcat(Text," players.");
	}
	message(user,Text);
}
admin_playerinfo() {
	new i;
	new MaxPlayers;
	new Name[MAX_NAME_LENGTH];
	new strNum[MAX_NUMBER_LENGTH];
	new Result;
	new UserID;
	new Text[MAX_TEXT_LENGTH];
	new WONID;
	
	MaxPlayers = maxplayercount();
	message(user,"--- Player Info ---");
	for(i = 1; i <= MaxPlayers; i++) {
		Result = playerinfo(i,Name,MAX_NAME_LENGTH,UserID,WONID);
		if (Result==1) {
			strncpy(Text, "Player #", MAX_TEXT_LENGTH);
			NumToStr(i,strNum);
			strcat(Text,strNum);
			strcat(Text,": ");
			strcat(Text,Name);
			strcat(Text,"  ");
			NumToStr(UserID,strNum);
			strcat(Text,strNum);
			strcat(Text,"  ");
			NumToStr(WONID,strNum);
			strcat(Text,strNum);
			message(user,Text);
		}
	}
	message(user,"-------------------");
}

admin_prematch(Prematch[]) {
	if (CheckAuth(ACCESS_PREMATCH)==0) {
		message(user,STRING_DENIED);
		return;
	}
	ExecuteCommand("tfc_clanbattle_prematch", Prematch);
}

admin_psay(cmddata[]) {
	new Target[MAX_NAME_LENGTH];
	new TargetName[MAX_NAME_LENGTH];
	new Msg[MAX_DATA_LENGTH];
	
	if (CheckAuth(ACCESS_SAY)==0) {
		message(user,STRING_DENIED);
		return;
	}

	strbreak(cmddata, Target, Msg, MAX_TEXT_LENGTH);
	if (Msg[0] == NULL_CHAR) {
		message(user, "Unparsable format: no message found.");
		return;
	} else if ( check_user(Target) == 0) {
		message(user,"Unrecognized player: ");
		message(user,Target);
		return;
	}
	get_username(Target,TargetName,MAX_NAME_LENGTH);

	new Text[MAX_TEXT_LENGTH] = "(Private Message From ";
	strcat(Text, user);
	strcat(Text, "): ");
	strcat(Text, Msg);
	messageex(TargetName, Text, print_chat);
	LogCommand();
}

admin_restartround(RestartRound[]) {
	if (CheckAuth(ACCESS_RESTART)==0) {
		message(user,STRING_DENIED);
		return;
	}
	ExecuteCommand("sv_restartround",RestartRound);
}

#if ENABLE_RCON==1
admin_rcon(RconCmd[]) {
	if (CheckAuth(ACCESS_RCON)==0) {
		message(user,"<snort> Yeah, right.");
		return;
	}
	if (strmatch(RconCmd, "rcon_password", strlen("rcon_password"))==1) {
		message(user, STRING_DENIED);
		return;
	}
	ExecuteCommand("", RconCmd);
}
#endif

admin_say(msg[]) {
	if (CheckAuth(ACCESS_SAY)==0) {
		message(user,STRING_DENIED);
		return;
	}
	new Prefix[MAX_TEXT_LENGTH] = "Message from Admin ( ";    
	strcat(Prefix, user);
	strcat(Prefix, " ): ");
	strcat(Prefix, msg);
	say(Prefix);
}

#if ENABLE_JAGUAR_STUFF==1
admin_slap(slap_user[]) {
	new Text[MAX_TEXT_LENGTH];
	new TargetName[MAX_NAME_LENGTH];
	
	if (CheckAuth(ACCESS_SLAP)==0) {
		message(user,STRING_DENIED);
		return;
	}
	if ( check_user(slap_user) == 1) {
		get_username(slap_user,TargetName,MAX_NAME_LENGTH);
		SayCommand();
		if(access(ACCESS_IMMUNITY, TargetName)!=0) {
			strncpy(Text, "Laf.  You can't slap ", MAX_TEXT_LENGTH);
			strcat(Text,TargetName);
			strcat(Text, ", you silly bear.");
			say(Text);
		} else { 
			slap(slap_user);
		} 
	} else {
		message(user,"Unrecognized player: ");
		message(user,slap_user);
	}
}
#endif

admin_slay(slay_user[]) {
	new Text[MAX_TEXT_LENGTH];
	new TargetName[MAX_NAME_LENGTH];
	
	if (CheckAuth(ACCESS_SLAY)==0) {
		message(user,STRING_DENIED);
		return;
	}
	if ( check_user(slay_user) == 1) {
		get_username(slay_user,TargetName,MAX_NAME_LENGTH);
		SayCommand();
		if(access(ACCESS_IMMUNITY, TargetName)!=0) {
			strncpy(Text, "Laf.  You can't slay ", MAX_TEXT_LENGTH);
			strcat(Text,TargetName);
			strcat(Text, ", you silly bear.");
			say(Text);
		} else {				
			execclient(slay_user,"kill");
		}
	} else {
		message(user,"Unrecognized player: ");
		message(user,slay_user);
	}
}

/* Silent say: does an admin_say, but without showing the user name; exactly as if you did a 
'say' from console, or via rcon. */
admin_ssay(msg[]) {
	if (CheckAuth(ACCESS_SAY)==0) {
		message(user,STRING_DENIED);
		return;
	}
	say(msg);
	LogCommand();
}

admin_stack(CallerSessionID) {
	new i;
	new maxplayers = maxplayercount();
	new Result;
	new SessionID;
	new strSessionID[MAX_NUMBER_LENGTH];
	new WONID;
	new X;
	new Y;
	new Z;
	new Name[MAX_NAME_LENGTH];
	
	if (CheckAuth(ACCESS_TELEPORT)==0) {
		message(user,STRING_DENIED);
		return;
	}
	NumToStr(CallerSessionID, strSessionID);
	get_userorigin(strSessionID,X,Y,Z);
	for (i=1; i<=maxplayers; i++) {
		Result = playerinfo(i,Name,MAX_NAME_LENGTH,SessionID,WONID);
		if(Result==1) {
			if(access(ACCESS_IMMUNITY, Name)==0 && SessionID!=CallerSessionID) {
				Z += 96;
				NumToStr(SessionID, strSessionID);
				teleport(strSessionID, X, Y, Z);
			}
		}
	}
	SayCommand();
}

admin_teamcount() {
	new i;
	new Count;
	new Text[MAX_TEXT_LENGTH];
	new strNum[MAX_NUMBER_LENGTH];
	
	for(i = 0; i <= 5; i++) {
		strncpy(Text, "Team #", MAX_TEXT_LENGTH);
		NumToStr(i,strNum);
		strcat(Text,strNum);
		strcat(Text," has **");
		Count = getteamcount(i);
		NumToStr(Count,strNum);
		strcat(Text,strNum);
		strcat(Text,"** players.");
		message(user,Text);
	}
}	

admin_teamplay(Teamplay[]) {
	if (CheckAuth(ACCESS_TEAMPLAY)==0) {
		message(user,STRING_DENIED);
		return;	
	}
	ExecuteCommand("mp_teamplay",Teamplay);
}

/* Usage of admin_teleport:

admin_teleport <player> <X> <Y> <Z>

<player> = Player, of course.  Can be name, WON ID, Session ID, etc.
<X>, <Y>, <Z> = Integer numbers.  Use admin_userorigin to find these.

eg:
admin_teleport jaguar 30 400 -350

*/
admin_teleport(teleport_data[]) {
	new X = 0;
	new Y = 0;
	new Z = 0;
	new teleport_data2[MAX_DATA_LENGTH];
	new TeleportUser[MAX_NAME_LENGTH];
	new strNumber[MAX_NUMBER_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	
	if (CheckAuth(ACCESS_TELEPORT)==0) {
		message(user,STRING_DENIED);
		return;
	}
	
	strbreak(teleport_data, TeleportUser, teleport_data2, MAX_DATA_LENGTH);
	if(teleport_data2[0]==NULL_CHAR) {
		message(user, "Unparsable format: no X value found.");
		return;
	} 
	strncpy(Text, "Attempting teleport of '", MAX_TEXT_LENGTH);
	strcat(Text, TeleportUser);
	
	strncpy(teleport_data, teleport_data2, MAX_DATA_LENGTH);
	strbreak(teleport_data, strNumber, teleport_data2, MAX_DATA_LENGTH);
	if(teleport_data2[0]==NULL_CHAR) {
		message(user, "Unparsable format: no Y value found.");
		return;
	} 
	X = strtonum(strNumber);
	strcat(Text, "' to X: '");
	strcat(Text, strNumber);
	
	strncpy(teleport_data, teleport_data2, MAX_DATA_LENGTH);
	strbreak(teleport_data, strNumber, teleport_data2, MAX_DATA_LENGTH);
	if(teleport_data2[0]==NULL_CHAR) {
		message(user, "Unparsable format: no Z value found.");
		return;
	} 
	Y = strtonum(strNumber);
	strcat(Text, "'  Y: '");
	strcat(Text, strNumber);

	Z = strtonum(teleport_data2);
	strcat(Text, "'  Z: '");		
	strcat(Text, strNumber);
	strcat(Text, "'");

	message(user,Text);
	
	if(teleport(TeleportUser,X,Y,Z)==1) {
		message(user,"Succeeded.");
		strncpy(Text, "ADMIN Command: ", MAX_TEXT_LENGTH);
		strcat(Text, user);
		strcat(Text, " used command admin_teleport ");
		strcat(Text, TeleportUser);
		say(Text);
		LogCommand();
	} else {
		message(user,"Failed.");
	}
}

admin_timelimit(Timelimit[]) {
	if (CheckAuth(ACCESS_TIMELIMIT)==0) {
		message(user,STRING_DENIED);
		return;
	}
	ExecuteCommand("mp_timelimit",Timelimit);
}

admin_unban(ban_user[]) {
	new Cmd[MAX_DATA_LENGTH];
	
	if (CheckAuth(ACCESS_BAN)==0) {
		message(user,STRING_DENIED);
		return;
	}

	if(strlen(ban_user)>=7 && strlen(ban_user)<=15 && strcount(ban_user, PERIOD_CHAR)==3) {
		message(user, "Name recognized as IP address.");
		strncpy(Cmd,"removeip ",MAX_DATA_LENGTH);
		strcat(Cmd,ban_user);
		exec(Cmd);
		exec("writeip");
	} else {
		unban(ban_user);
	}
	LogCommand();
}

admin_ungag(gag_user[]) {
	new UserID = 0;
	
	if (CheckAuth(ACCESS_GAG)==0) {
		message(user,STRING_DENIED);
		return;
	}
	if (check_user(gag_user)==1) {
#if INDEX_BY_WONID==1
		get_userWONID(gag_user,UserID);
#else
		get_userSessionID(gag_user,UserID);
#endif
		SayCommand();
		new UserIndex = GetUserIndex(UserID);
		if (UserIndex!=USER_INVALID) {
			UserGagTime[UserIndex] = GAG_INVALID;
		}
	} else {
		message(user, "Unrecognized player: ");
		message(user, gag_user);
	}
}

/* Usage:

admin_userorigin <player>

<Player> = Player.  May be name, WON ID, Session ID, etc.

eg, 

admin_userorigin jaguar

Will show you the X, Y, and Z coordinates of the player.
*/
admin_userorigin(origin_user[]) {
	new Text[MAX_TEXT_LENGTH];
	new strNumber[MAX_NUMBER_LENGTH];
	new X = 0;
	new Y = 0;
	new Z = 0;
	
	if (CheckAuth(ACCESS_TELEPORT)==0) {
		message(user,STRING_DENIED);
		return;
	}
	if (check_user(origin_user)==1) {
		if (get_userorigin(origin_user, X, Y, Z)==1) {
			strncpy(Text, "Success: X: ", MAX_TEXT_LENGTH);
			NumToStr(X, strNumber);
			strcat(Text, strNumber);
			strcat(Text, "  Y: ");
			NumToStr(Y, strNumber);
			strcat(Text, strNumber);
			strcat(Text, "  Z: ");
			NumToStr(Z, strNumber);
			strcat(Text,strNumber);
			message(user, Text);			
		} else {
			message(user, "Failed.");
		}
	} else {
		message(user, "Unrecognized player: ");
		message(user, origin_user);
	}
}

#if ENABLE_VOTE_ANY==1
admin_vote_any(VoteData[]) {
	if (CheckAuth(ACCESS_VOTE_ANY)==0) {
		message(user,STRING_DENIED);
		return;
	}
	if (strmatch(VoteData, "rcon_password", strlen("rcon_password"))==1) {
		message(user, STRING_DENIED);
		return;
	}
	new msg[MAX_DATA_LENGTH] = "Execute command: ";
	strcat(msg,VoteData);
	strcat(msg,"?");
	vote(msg,"Yes","No","HandleAnyVote",VoteData);
	LogCommand();
}
#endif

admin_vote_kick(kick_user[]) {
	new Text[MAX_TEXT_LENGTH];
	
	if (CheckAuth(ACCESS_VOTE_KICK)==0) {
		message(user, STRING_DENIED);
		return;
	}
	if (vote_allowed()!=1) {
		message(user, "Vote not allowed at this time.");
		return;
	}
	if (check_user(kick_user) == 1) {
		new real_user[MAX_NAME_LENGTH];
		get_username(kick_user,real_user,MAX_NAME_LENGTH);
		SayCommand();
		if(access(ACCESS_IMMUNITY, real_user)!=0) {
			strncpy(Text, "Laf.  You can't kick ", MAX_TEXT_LENGTH);
			strcat(Text,real_user);
			strcat(Text, ", you silly bear.");
			say(Text);
		} else {
			new msg[MAX_DATA_LENGTH] = "Kick ";
			strcat(msg,real_user);
			strcat(msg,"?");
			vote(msg,"Yes","No","HandleKickVote",real_user);
		}
	} else {
		message(user,"Unrecognized user name ");
		message(user,kick_user);
	}
}

admin_vote_map(map[]) {
	if (CheckAuth(ACCESS_VOTE_MAP)==0) {
		message(user, STRING_DENIED);
		return;
	}
#if ENABLE_HLDSLD_MAP_VOTE==1
	if (vote_allowed()!=1 || MapVoteStatus!=VoteNotBegun) {
		message(user, "Vote not allowed at this time.");
		return;
	}
#else
	if (vote_allowed()!=1) {
		message(user, "Vote not allowed at this time.");
		return;
	}
#endif
	if (valid_map(map) == 1) {
		SayCommand();
		new msg[MAX_DATA_LENGTH] = "Change map to ";
		strcat(msg,map);
		strcat(msg,"?");
		vote(msg,"Yes","No","HandleMapVote",map);
	} else {
		message(user,"Unrecognized map name ");
		message(user,map);
	}
}

admin_reload() {
	if(CheckAuth(ACCESS_RELOAD)==0) {
		message(user,STRING_DENIED);
		return;
	}
	reload();
}

/*
*
* Main function called when a client enters a command into the console
*
*/
public client_commands(HLCommand,HLData,HLUser,HLSessionID,HLWONID) {
	new Text[MAX_TEXT_LENGTH];
	
	convert_string(HLCommand,command,MAX_COMMAND_LENGTH);
	strinit(data,MAX_DATA_LENGTH);
	convert_string(HLData,data,MAX_DATA_LENGTH);
	convert_string(HLUser,user,MAX_NAME_LENGTH);
	
	new ProcessedCommand = 0;
	new i;
		
	new Length = strlen(command);
	new ParseCommand[MAX_COMMAND_LENGTH];
	for(i=0;i<=MAX_COMMAND_LENGTH;i++)
		ParseCommand[i] = command[i];
	for(i=0;i<=Length;i++) {
		if (ParseCommand[i] == ' ' || ParseCommand[i] == NULL_CHAR)
			break;
		ParseCommand[i] = tolower(ParseCommand[i]);
	}

	if(strmatch(ParseCommand, "admin_",MAX_COMMAND_LENGTH)==1) {
		if(streq(ParseCommand, "admin_ban")==1)
			admin_ban(data);
		else if(streq(ParseCommand, "admin_cfg")==1)
			admin_cfg(data);
		else if(streq(ParseCommand, "admin_chat")==1)
			admin_chat(data);
		else if(streq(ParseCommand, "admin_csay")==1)
			admin_csay(data);
		else if(streq(ParseCommand, "admin_currentmap")==1)
			currentmap(Text,0);
		else if(streq(ParseCommand, "admin_debug")==1)
			admin_debug(1);
#if ENABLE_EXECCLIENT==1
		else if(streq(ParseCommand, "admin_execall")==1)
			admin_execall(data);
#endif
#if ENABLE_EXECCLIENT==1
		else if(streq(ParseCommand, "admin_execclient")==1)
			admin_execclient(data);
#endif
		else if(streq(ParseCommand, "admin_fraglimit")==1)
			admin_fraglimit(data);
		else if(streq(ParseCommand, "admin_gag")==1)
			admin_gag(data);
		else if(streq(ParseCommand, "admin_gravity")==1)
			admin_gravity(data);
		else if(streq(ParseCommand, "admin_help")==1)
			help(data);
		else if(streq(ParseCommand, "admin_kick")==1)
			admin_kick(data);
		else if(streq(ParseCommand,"admin_listmaps")==1)
        	admin_listmaps();
		else if(streq(ParseCommand, "admin_map")==1)
			admin_map(data);
		else if(streq(ParseCommand, "admin_nextmap")==1)
			nextmap(Text,0);
		else if(streq(ParseCommand, "admin_nopass")==1)
			admin_pass("^"^"");
		else if(streq(ParseCommand, "admin_pass")==1)
			admin_pass(data);
		else if(streq(ParseCommand, "admin_pause")==1)
			admin_pause(1);
		else if(streq(ParseCommand, "admin_playercount")==1)
			admin_playercount();
		else if(streq(ParseCommand, "admin_playerinfo")==1)
			admin_playerinfo();
		else if(streq(ParseCommand, "admin_prematch")==1)
			admin_prematch(data);
		else if(streq(ParseCommand, "admin_psay")==1)
			admin_psay(data);
#if ENABLE_RCON==1
		else if(streq(ParseCommand, "admin_rcon")==1)
			admin_rcon(data);
#endif
		else if(streq(ParseCommand, "admin_reload")==1)
			admin_reload();
		else if(streq(ParseCommand, "admin_restartround")==1)
			admin_restartround(data);
		else if(streq(ParseCommand, "admin_say")==1)
			admin_say(data);
#if ENABLE_JAGUAR_STUFF==1
		else if(streq(ParseCommand, "admin_slap")==1)
			admin_slap(data);
#endif
		else if(streq(ParseCommand, "admin_slay")==1)
			admin_slay(data);
		else if(streq(ParseCommand, "admin_ssay")==1)
			admin_ssay(data);
		else if(streq(ParseCommand, "admin_stack")==1)
			admin_stack(HLSessionID);
		else if(streq(ParseCommand, "admin_teamcount")==1)
			admin_teamcount();
		else if(streq(ParseCommand, "admin_teamplay")==1)
			admin_teamplay(data);
		else if(streq(ParseCommand, "admin_teleport")==1)
			admin_teleport(data);
		else if(streq(ParseCommand, "admin_timeleft")==1)
			timeleft();
		else if(streq(ParseCommand, "admin_timelimit")==1)
			admin_timelimit(data);
		else if(streq(ParseCommand, "admin_unban")==1)
			admin_unban(data);
		else if(streq(ParseCommand, "admin_undebug")==1)
			admin_debug(0);
		else if(streq(ParseCommand, "admin_ungag")==1)
			admin_ungag(data);
		else if(streq(ParseCommand, "admin_unpause")==1)
			admin_pause(0);
		else if(streq(ParseCommand, "admin_userlist")==1)
			userlist();
		else if(streq(ParseCommand, "admin_userorigin")==1)
			admin_userorigin(data);
		else if(streq(ParseCommand, "admin_version")==1)
			version();
#if ENABLE_VOTE_ANY==1
		else if(streq(ParseCommand, "admin_vote_any")==1)
			admin_vote_any(data);
#endif
		else if(streq(ParseCommand, "admin_vote_kick")==1)
			admin_vote_kick(data);
		else if(streq(ParseCommand, "admin_vote_map")==1)
			admin_vote_map(data);
		else if(streq(ParseCommand, "admin_enable")==1)
			admin_enable(data);
		else if(streq(ParseCommand, "admin_disable")==1)
			admin_disable(data);
		else if(streq(ParseCommand, "admin_set")==1)
			admin_set(data);
		else if(streq(ParseCommand, "admin_var")==1)
			admin_var(data);
		else
			message(user, "Unrecognized admin command.");
		ProcessedCommand = 1;
	} else {
#if ENABLE_WORD_CHECK==1
		if ( check_words(data)==0) {
			message(user,"You are not allowed to swear on this server.");
			return 1;
		}
#endif

/* Check to see if this person is gagged */
#if INDEX_BY_WONID==1
		new UserID = HLWONID;
#else
		new UserID = HLSessionID;
#endif
#if ENABLE_GAG_SAYTEAM==1
		if (streq(ParseCommand, "say")==1 || streq(ParseCommand, "say_team")==1) {
#else
		if (streq(ParseCommand, "say")==1) {
#endif
			new UserIndex = GetUserIndex(UserID);
			if (UserIndex!=USER_INVALID) {
				if (UserGagTime[UserIndex]!=GAG_INVALID) {
					if (timeleft() < UserGagTime[UserIndex]) {
						UserGagTime[UserIndex] = GAG_INVALID;
					} else {
						messageex(user, "[ADMIN] You are currently gagged, and cannot speak.", print_chat);
						ProcessedCommand = 1;
					}
				}
			}
		}
		
#if ENABLE_CHAT_COMMANDS==1
		if (streq(ParseCommand, "say")==1 && ProcessedCommand==0) {
			/* Strip out quotes */
			strstripquotes(data);
			ProcessedCommand = HandleSay(UserID,data);
		}
#endif
	}

	return ProcessedCommand;
}
