#if defined USE_CUSTOM_DLL
#if USE_CUSTOM_DLL==1
native maptime(whichtime,printtime);
#endif
#endif


///////////////////////////////////////////////////////////////////////////////
// Finds first occurence of str2 in str1.  Returns the position of str2 if
// found in str1, otherwise returns 0.
///////////////////////////////////////////////////////////////////////////////
strstr(str1[], str2[])
{
        new i = 0;
        new j = 0;
        new len1;
        new len2;

        len1 = strlen(str1);    // Length of source string
        len2 = strlen(str2);    // Length of string we're searching for

        // Step through str1
        for (j=0; j<len1; j++)
        {
                // If the current letter of str2 is the same as the current letter of str1
                while (str1[j+i] == str2[i])
                {
                        i++;
                        // If we are at the end of str2, then success!
                        if (i == len2)
                                return j;
                        // If we get to the end of str1, but not end of str2, then fail.
                        else if (len1 == j+i)
                                return -1;
                }

                // Re-initialize i to zero for next time around
                i = 0;
        }
        // If we don't find anything, and we get to the end, then return 0
        return -1;
}


///////////////////////////////////////////////////////////////////////////////
// Finds first occurence of str2 in str1.  Returns the position of str2 if
// found in str1, otherwise returns 0. The match is case-insensitive
///////////////////////////////////////////////////////////////////////////////
istrstr(str1[], str2[])
{
        new i = 0;
        new j = 0;
        new len1;
        new len2;

        len1 = strlen(str1);    // Length of source string
        len2 = strlen(str2);    // Length of string we're searching for

        // Step through str1
        for (j=0; j<len1; j++)
        {
                // If the current letter of str2 is the same as the current letter of str1
                while ( tolower(str1[j+i]) == tolower(str2[i]) )
                {
                        i++;
                        // If we are at the end of str2, then success!
                        if (i == len2)
                                return j;
                        // If we get to the end of str1, but not end of str2, then fail.
                        else if (len1 == j+i)
                                return -1;
                }

                // Re-initialize i to zero for next time around
                i = 0;
        }
        // If we don't find anything, and we get to the end, then return 0
        return -1;
}


/******************************************************************************
*
* Implements the strcmp function. Returns -1, 0, 1 if string1 is smaller, 
* EXACTLY equal or larger than string2
*
*******************************************************************************/

strcmp(string1[], string2[]) {

  new len1 = strlen(string1);
  new len2 = strlen(string2);
  new i = 0;

  if (len1 < len2) {
	return -1;
  }  // if

  if (len1 > len2) {
	return 1;
  }  // if

  // the strings have the same length, thus we start comparing them
  for ( i = 0; i < len1; i++ ) {
	if ( string1[i] < string2[i] ) {
	  return -1;
	}  // if
	if ( string1[i] > string2[i] ) {
	  return 1;
	}  //if
  }  // for

  return 0;
}


/******************************************************************************
*
* Implements the strcasecmp function. Returns -1, 0, 1 if string1 is smaller, 
* EXACTLY equal or larger than string2. The comparison ignores case.
*
*******************************************************************************/

strcasecmp(string1[], string2[]) {

  new len1 = strlen(string1);
  new len2 = strlen(string2);
  new i = 0;

  if (len1 < len2) {
	return -1;
  }  // if

  if (len1 > len2) {
	return 1;
  }  // if

  // the strings have the same length, thus we start comparing them
  for ( i = 0; i < len1; i++ ) {
	if ( tolower(string1[i]) < tolower(string2[i]) ) {
	  return -1;
	}  // if
	if ( tolower(string1[i]) > tolower(string2[i]) ) {
	  return 1;
	}  //if
  }  // for

  return 0;
}



/*******************************************************************************
*
* Check if a key is marked enabled '1' or diabled '0' in the
* server info contruct.
*
********************************************************************************/

is_enabled(key[]) {
	new value[2] = {0,0};
	new result = 0;
	
	result = get_serverinfo(key, value, 2);
	if ( result == 0 ) {
		return false;
	}  // if

	if ( value[0] == '1' ) {
		return true;
	}  // if

	return false;
}


/*********************************************************************************
*
* Return the numeric value of a key stored in the server info construct
*
***********************************************************************************/

get_serverinfo_int(key[]) {
	new value[20] = {0, ...};
	new result = 0;

	result = get_serverinfo(key, value, 20);
	if ( result > 0 ) {  // successful lookup
		result = strtonum(value);
	} // result

	return result;
}

