//// Segment Begin -- (JavaScript 1.2)
// eHelp Corporation Dynamic HTML JavaScript 
// Copyright 1998-2000 eHelp Corporation.All rights reserved.
// Version=4.45

// Warning:Do not modify this file.It is generated by RoboHELP and changes will be overwritten.


/// Section Begin  - kadov DHTM (JavaScript 1.2)

//Begin to support extended and dropdown text effects.
function kadovIsParagraph(el)
{
	return( el.tagName == "P" || el.tagName.indexOf("H") == 0 ) ? true : false;
}

function kadovInitEachChild(el)
{	
	for(var i=0; i<el.children.length; i++)
	{
		var child = el.children[i];
		if( child.tagName == "SCRIPT" || child.tagName == "!" )
			continue;

		if( child.id != "" )
		{
			// to wipe out the onload effects
			var onLoadEffect = child.style.getAttribute( "x-on-pageload" );
			if( (onLoadEffect != null) && (onLoadEffect > "") )
				child.style.setAttribute( "x-on-pageload", "" );
			
			var href = child.getAttribute("href")
			if( href != null && href > "" && href.indexOf( "BSSCPopup" ) >= 0 )
				kadovFilePopupInit(child.id); // Init for Popup
			else if( child.className == "dropspot" || child.className == "expandspot" || 
					 child.className == "glossterm" )
				kadovTextPopupInit(child.id);// Init for Expanding/Glossary or DropDown text
			else if( child.className == "trigger")
				kadovInitTrigger(child.id);// Init for Trigger
			else
			{
				kadovInitEffects(child.id);// Init for DHTML effects
				CEngine.SetOneTargetInitialState( child.id );
			}
		}
		
		if( (child.tagName == "IMG") && (child.getAttribute("dynsrc") > "") )
			child.start = "mouseover";// to start a AVI file. fileopen doesn't work

		kadovInitEachChild(child);
	}
}

function kadovRetrieveTextInner(el)
{	
	var x = "";
	if( (!el) || (el.tagName == "!") || (el.tagName == "SCRIPT" ))
		return x;

	if( kadovIsParagraph(el) )
	{
		var strNewID = " ";
		if( el.id != "" )
			strNewID += "id=" + el.id + "_NewSpan ";
		x = "<span" + strNewID + "style='" + el.style.cssText + "'>" + el.innerHTML + "</span>";
	}
	else
	{
		for(var i=0; i<el.children.length; i++)
			x += kadovRetrieveTextInner( el.children[i] );
	}
	return x;
}

function kadovRetrieveCleanHTML( strRawHTML, strTagOpen, strTagClose, nDistance )
{	
	var nTagOpen = strRawHTML.indexOf( strTagOpen, 0 );
	if( nTagOpen < 0 )
		return strRawHTML;

	var nTagClose = strRawHTML.indexOf( strTagClose, nTagOpen);
	if( nTagClose < nTagOpen )
		return strRawHTML;
		
	if( typeof(nDistance) == "number" && nDistance > 0 )
		if( (nTagClose - nTagOpen) != nDistance )
			return strRawHTML;
		
	var strCleanOnce = strRawHTML.substring(0, nTagOpen) + strRawHTML.substr(nTagClose + strTagClose.length) ;
	return 	kadovRetrieveCleanHTML( strCleanOnce, strTagOpen, strTagClose );
}

function kadovAdjustObjectTag(strRawHTML, nStartPos)
{// adjust object tag for related topics HTML control, because innerHTML misses out the item settings
	
	//Is there any DTC?
	var strDTCTagOpen = '<!--Metadata type="DesignerControl" startspan';
	var strDTCTagClose = '<!--Metadata type="DesignerControl" endspan-->';
	var nDTCTagOpen = strRawHTML.indexOf( strDTCTagOpen, nStartPos );
	if( nDTCTagOpen < 0 )
		return strRawHTML;
	var nDTCTagClose = strRawHTML.indexOf( strDTCTagClose, nDTCTagOpen );
	if( nDTCTagClose < nDTCTagOpen)
		return strRawHTML; // no Design Time Controls;
		
	//Is the DTC HTML Help Control?
	var strRTObjTagOpen = 'classid=clsid:ADB880A6-D8FF-11CF-9377-00AA003B7A11';
	var strRTObjTagClose = '</OBJECT>';
	var nRTObjTagOpen = strRawHTML.indexOf( strRTObjTagOpen, nDTCTagOpen );
	if( nRTObjTagOpen < nDTCTagOpen )
		return strRawHTML;
	var nRTObjTagClose = strRawHTML.indexOf( strRTObjTagClose, nRTObjTagOpen );
	if( nRTObjTagClose < nRTObjTagOpen )
		return strRawHTML; // is not a HTML help control
		
	// Is it a related Topics html help control?
	var strRTObjLabel = '<PARAM NAME=\"Command\" VALUE=\"Related Topics';
	if( strRawHTML.indexOf(strRTObjLabel, nRTObjTagOpen) < 0 )
		return strRawHTML;
	
	// does the commented object tag contain a items parameters		
	var strRTItemsOpen = '<param name=Items value="';
	var strRTItemsClose = '$$**$$" >';
	var nRTItemsOpen = strRawHTML.indexOf(strRTItemsOpen, nDTCTagOpen);
	if( nRTItemsOpen < nDTCTagOpen )
		return strRawHTML;
	var nRTItemsClose = strRawHTML.indexOf(strRTItemsClose, nRTItemsOpen);
	if( nRTItemsClose < nRTItemsOpen )
		return strRawHTML;
		
	// found a items string
	var strItems = strRawHTML.substring( nRTItemsOpen + strRTItemsOpen.length, nRTItemsClose);
	if( strItems.length < 1 )
		return strRawHTML;
	
	// to reconstruct the item(s) param tag(s)
	var strItemsArray = strItems.split('$$**$$');
	if( strItemsArray.length < 1 )
		return strRawHTML;
	var strRunTimeItemParam = "";
	for( var i = 0; i < strItemsArray.length; i++ )
	{
		strRunTimeItemParam += '<PARAM  NAME="Item' + (i+1);
		strRunTimeItemParam += '"' + '  VALUE="';
		strRunTimeItemParam += strItemsArray[i];
		strRunTimeItemParam += '">';
	}
	
	// to insert the reconstructed item params into runtime object tag
	var strAdjustedHTML = strRawHTML.substring(0,nRTObjTagClose) + strRunTimeItemParam + strRawHTML.substring(nRTObjTagClose, strRawHTML.length);
	return kadovAdjustObjectTag(strAdjustedHTML, nDTCTagClose + strDTCTagClose.length);
}

function kadovTextPopupOnLoad( el )
{
	if( !CCSSP.bIsWinOS )
		return;

	if( typeof(el) == "string" )
		el = document.all.item(el);

	var src = el.getAttribute( "x-use-popup" );
	if(!src)
		return;

	var name = src;
	if( src.substr(0,1) == "#" ) 
		name = src.substr(1, src.length-1);
	var srcDiv = document.all.item(name);
	if( !srcDiv )
		return 1;

	var type = el.getAttribute( "x-popup-type" );
	var setup = el.getAttribute( "x-tmp-setup" );
	var newId = name;
	if( newId.indexOf( "_tmp") <= 0 )
		newId += "_tmp";

	if( !setup )
	{
		el.setAttribute( "x-tmp-setup", 1 );
	
		if( type == "pulldown"  )
		{
			var strAdjust = kadovAdjustObjectTag(srcDiv.innerHTML,0);
			var strCleanHTML = kadovRetrieveCleanHTML(strAdjust, "<!--", "-->");
			strCleanHTML = kadovRetrieveCleanHTML(strCleanHTML, "<SCRIPT", "/SCRIPT>");

			//work around the bug in HH.exe that highlight the phrases when use Search tab
			//this approach is just removing the <FONT...> tag inserted by Microsoft in the runtime
			strCleanHTML = kadovRetrieveCleanHTML(strCleanHTML, "<FONT color=#", "\">", 52);
			
			var strStyle = " style='display:none; position:relative;";
			var newDiv = "<div class=droptext id=" + newId + strStyle + "'>" + strCleanHTML + "</div>";

			srcDiv.outerHTML = ""; // empty the original DIV tag
			var elParentPra = kadovFindParentParagraph(el);
			if( elParentPra )
				elParentPra.insertAdjacentHTML( "AfterEnd", newDiv );
		}
		else if( type == "expanding"  )
		{
			var inner = kadovRetrieveTextInner(srcDiv);
			if( inner == "" )
				inner = srcDiv.innerHTML;
			var strAdjust = kadovAdjustObjectTag(inner,0);
			var strCleanHTML = kadovRetrieveCleanHTML(strAdjust, "<!--", "-->");
			strCleanHTML = kadovRetrieveCleanHTML(strCleanHTML, "<SCRIPT", "/SCRIPT>");
			var strClassName = (el.className == "glossterm") ? "glosstext" : "expandtext";
			var newSpan = "<span class=" + strClassName + " style='display: none;' id=" + newId + ">&nbsp;" + strCleanHTML + "</span>";
			srcDiv.outerHTML = ""; // empty the original DIV tag
			el.insertAdjacentHTML( "AfterEnd", newSpan );
		}
	}
}

function kadovTextPopup( el )
{
	if( (!CCSSP.bIsWinOS) || (window.event == null) )
		return;
	window.event.cancelBubble = true;

	if( typeof(el) == "string" )
		el = document.all.item(el);

	var src = el.getAttribute( "x-use-popup" );
	if(!src)
		return 1;

	var name = src;
	if( src.substr(0,1) == "#" ) 
		name = src.substr(1, src.length-1) + "_tmp";
	var srcDiv = document.all.item(name);
	if( !srcDiv )
		return 1;

	var type = el.getAttribute( "x-popup-type" );
	var setup = el.getAttribute( "x-tmp-setup" );
	if( srcDiv )
	{
		if( srcDiv.style.display == "" )
			srcDiv.style.display = "none";
		else
		{
			srcDiv.style.display = "";
			if( typeof(srcDiv.bInitialized) == "undefined" )
			{
				srcDiv.bInitialized = true;
				kadovInitEffects(name);
				kadovInitEachChild(srcDiv);
			}
		}
	}
}

function kadovFindParentParagraph( el )
{
	if( typeof(el) == "string" )
		el = document.all.item(el);
	if( (!el) || el.tagName == "BODY" )
		return null;
	if( kadovIsParagraph(el.parentElement) )
		return el.parentElement;
	else
		return kadovFindParentParagraph( el.parentElement );
}

//Begin HTML code invoked function
function kadovRegisterEventHandler( obj, strEvent, strEventHandler )
{
	if( !gbBsIE4 )
		return;
	CCSSP.RegisterEventHandler( obj, strEvent, strEventHandler );
}

function kadovTextPopupInit( el )
{
	if( (!gbBsIE4) || (!CCSSP.bIsWinOS) )
		return;
		
	if( typeof(el) == "string" )
		el = document.all.item(el);
	if( el != null )
	{
		CCSSP.RegisterEventHandler( el, "onclick", "kadovTextPopup(" + el.id +");" );
		CCSSP.RegisterEventHandler( window, "onload", "kadovTextPopupOnLoad(" + el.id +");" );
	}
}
//End HTML code invoked function

//End to support extended and dropdown text effects.

//Begin to convert iWrite format to RoboEditor Format for DHTML effects
function kadovInitTriggersInHead( )
{
  if( Object.xDelayedInitElements )
  {
     var x = Object.xDelayedInitElements;
     for(i=0; i<x.length; i++)
     	kadovInitTrigger( x[i] );
  }
}

//Begin HTML code invoked function
function kadovFilePopupInit( el )
{
	if( !gbBsIE4 )
		return;
	if( typeof(el) == "string" )
		el = document.all.item(el);

	if( el != null )
		CCSSP.RegisterEventHandler( el, "onmouseover", "BSPSPopupOnMouseOver(event);" );
}

function kadovInitTrigger( element )
{
	if( !gbBsIE4 )
		return;
	var srcElement = element;
	if( typeof(srcElement) == "string" )
	{
		srcElement = document.all.item(element,0);
		if(srcElement == null)
			return;
	}
	
	if( !kadovIsParentVisible(srcElement) )
		return;

	var targets = srcElement.getAttribute( "x-targets" );
	var arrOneTarget = targets.split( "," );
	for( var i = 0; i < arrOneTarget.length; i ++ )
		bsscFXInit( element, arrOneTarget[i], null, null, null, null );
}

function kadovIsParentVisible( el )
{
	if( typeof(el) == "string" )
		el = document.all.item(el);
	if( (!el) || el.tagName == "BODY" )
		return true;
	if( el.style.display == 'none' ) //el.visibility == 'hidden' || 
		return false;
	else
		return kadovIsParentVisible( el.parentElement );
}

function kadovInitEffects( element )
{
	if( !gbBsIE4 )
		return;
	var srcElement = element;
	if( typeof(srcElement) == "string" )
	{
		srcElement = document.all.item(element,0);
		if(srcElement == null)
			return;
	}
	
	if( !kadovIsParentVisible(srcElement) )
		return;
	
	kadovInitEffect( srcElement, "x-on-hover" );
	kadovInitEffect( srcElement, "x-on-pageclick" );
	kadovInitEffect( srcElement, "x-on-pageload" );
	kadovInitEffect( srcElement, "x-on-trigger-1" );
	kadovInitEffect( srcElement, "x-on-trigger-2" );
}
//End HTML code invoked function

function kadovInitEffect( element, prop )
{
	var values = null;
	if( element.getAttribute( "currentStyle" ) )
		values = element.currentStyle.getAttribute( prop );
	else 
		values = element.style.getAttribute( prop );
	if( !values )
		return;

	var functions = new Array();
	var nIdx = 0, nStart = 0;
	var nNext = values.indexOf( "\)", 0);
	while( nNext >= 0 && nNext < values.length )
	{
		functions[nIdx] = values.substr( nStart, nNext-nStart+1);
		nStart = nNext + 1;
		nIdx++;
		nNext = values.indexOf( "\)", nStart);
	}
		
	for( var i=0; i<functions.length; i++)
	{
		var id = element.getAttribute( "id" );
		var translatedProp = kadovTranslateProp(prop);

		var lp = functions[i].indexOf( "(" );
		var fnname = functions[i].substring(0, lp);
		var srcargs = functions[i].substring(lp+1, functions[i].length-1);
		
		var nClickTimes = 1;
		var arrForClickCount = srcargs.split( "," );
		for( var j = 0; j < arrForClickCount.length; j++ )
		{// to locate and get the "clicks=99" settings
			var nPageClick = arrForClickCount[j].indexOf("clicks");
			if( nPageClick >= 0 )
			{
				nPageClick = arrForClickCount[j].indexOf("=");
				if( nPageClick > 0 )
				{
					nClickTimes = arrForClickCount[j].substring( nPageClick + 1, arrForClickCount[j].length) * 1;
					break;
				}
			}
		}
		var args = srcargs;
		if( j < arrForClickCount.length )
		{// to strip out the "clicks=99" from the arguments string
			args = "";
			for( var k = 0; k < arrForClickCount.length; k ++ )
			{
				if( k != j )
				{
					args += arrForClickCount[k];
					if( k < arrForClickCount.length - 1 )
						args += ",";
				}
			}
		}
		bsscFXInit( null, id, translatedProp, fnname, args, nClickTimes );
	}
}

function kadovTranslateProp( prop )
{
	switch( prop )
	{
	case "x-on-hover" :     return "bsschover";
	case "x-on-pageclick" : return "bsscpageclick";
	case "x-on-pageload" :  return "bsscpageload";
	case "x-on-trigger-1" : return "bssctrigger1";
	case "x-on-trigger-2" : return "bssctrigger2";
	}
	return null;
}
//End to convert iWrite format to RoboEditor Format for DHTML effects

//Begin the definition of one entry to DHTML effects
function bsscFXInit( trigger_ID, target_ID, event_type, 
	action_type, action_setting, event_addional )
{
	if( !CCSSP.bIsWinOS || typeof(target_ID) != "string" )//MUST have a target_ID
		return; // we don't support Navigator yet
	
	if( typeof(event_type) == "string" )
		event_type = event_type.toLowerCase();
	if( typeof(action_type) == "string" )
		action_type = action_type.toLowerCase();
	if( typeof(action_setting) == "string" )
		 action_setting = action_setting.toLowerCase();
	
	// to get the target element then add it to the target list
	var eleTarget = CCSSP.GetObject( target_ID );
	if( (eleTarget != null) && (event_type != null) && (action_type != null) )
	{
		CEngine.AddOneTarget( target_ID, eleTarget );
		CEngine.BuildTargetObject(target_ID, event_type, action_type, action_setting, event_addional);
	}
	
	// to validate the trigger_ID parameter
	if( typeof(trigger_ID) == "string" && trigger_ID != "" )
		CEngine.BuildTriggerObject( trigger_ID, target_ID );
}	
//End the definition of one entry to DHTML effects


/// Section End  - kadov DHTM (JavaScript 1.2)


/// Section Begin  - CCSSP DHTM (JavaScript 1.2)

//Begin JavaScript libary for cross-platform positioning object.
function CCSSP(){} // constructor of CCSSP class

CCSSP.strAgent = navigator.userAgent.toLowerCase(); 
CCSSP.nAppVersion = parseInt(navigator.appVersion);

CCSSP.bIsWinOS = ((CCSSP.strAgent.indexOf("win") >= 0) || (CCSSP.strAgent.indexOf("16bit") >= 0));
CCSSP.bIsMacOS = (CCSSP.strAgent.indexOf("mac") >= 0);

CCSSP.bIsIE = (navigator.appName.indexOf("Microsoft") >= 0);
CCSSP.bIsIE4 = (CCSSP.bIsIE && (CCSSP.nAppVersion >= 4));
CCSSP.bIsIE5 = (CCSSP.bIsIE4 && (CCSSP.strAgent.indexOf("msie 5") != -1) )

CCSSP.bIsNav = (navigator.appName.indexOf("Netscape") >= 0);
CCSSP.bIsNav4 = (CCSSP.bIsNav && (CCSSP.nAppVersion >= 4));

CCSSP.GetObject = function( obj )
{//convert object name string or reference into a valid object reference
	if( typeof(obj) == "object" )
		return obj;
	else if( typeof(obj) == "string" && obj != "")
	{
		if( CCSSP.bIsNav4 )
			return eval("document." + obj);
		else
			return eval("document.all." + obj);
	}
	else
		return null;
}

CCSSP.MoveObjectTo = function(obj, x, y)
{//positioning an object at a specific pixel coordinate
	if( CCSSP.bIsNav4 )
		obj.moveTo(x,y);
	else
	{
		obj.style.pixelLeft = x;
		obj.style.pixelTop = y;
	}
}

CCSSP.MoveObjectBy = function(obj, dx, dy)
{//moveing a object by x and/or y pixel
	if( CCSSP.bIsNav4 )
		obj.moveBy(dx,dy);
	else
	{
		obj.style.pixelLeft += dx;
		obj.style.pixelTop += dy;
	}
}

CCSSP.SetObjectBGColor = function(obj, color)
{//set the background color of an object
	if( CCSSP.bIsNav4 )
		obj.bgColor = color;
	else
		obj.style.backgroundColor = color;
}

CCSSP.ShowObject = function(obj, bShow)
{// set the object to be visible or invisible
	if( CCSSP.bIsNav4 )
		obj.visibility = (bShow == true) ? 'show' : 'hide';
	else
		obj.style.visibility = (bShow == true) ? 'visible' : 'hidden';// when hidden, it still occupy some space.
}

CCSSP.GetObjectLeft = function(obj)
{// retrieve the x coordinate of a posionable object
	if( CCSSP.bIsNav4 )
		return obj.left;
	else
		return obj.style.pixelLeft;
}

CCSSP.GetObjectTop = function(obj)
{// retrieve the y coordinate of a posionable object
	if( CCSSP.bIsNav4 )
		return obj.top;
	else
		return obj.style.pixelTop;
}

CCSSP.GetObjectContainLeft = function(obj)
{// retrieve the x coordinate of a posionable object relative to it's parent element
	if( CCSSP.bIsNav4 )
		return obj.pageX;
	else
	{
		if( obj == document.body )
			return obj.clientLeft;
		else
			return obj.offsetLeft;
	}
}

CCSSP.GetObjectWindowLeft = function(obj)
{// retrieve the x coordinate of a posionable object relative to browser window
	if( CCSSP.bIsNav4 )
		return obj.pageX;
	else
	{
		var nOffsetWindowLeft = 0;
		for(var element = obj; element; element = element.offsetParent)
			nOffsetWindowLeft += CCSSP.GetObjectContainLeft(element);
		return nOffsetWindowLeft;
	}
}

CCSSP.GetObjectContainTop = function(obj)
{// retrieve the y coordinate of a posionable object relative to it's parent element
	if( CCSSP.bIsNav4 )
		return obj.pageY;
	else
	{
		if( obj == document.body )
			return obj.clientTop;
		else
			return obj.offsetTop;
	}
}

CCSSP.GetObjectWindowTop = function(obj)
{// retrieve the y coordinate of a posionable object relative to browser window
	if( CCSSP.bIsNav4 )
		return obj.pageY;
	else
	{
		var nOffsetWindowTop = 0;
		for(var element = obj; element; element = element.offsetParent)
			nOffsetWindowTop += CCSSP.GetObjectContainTop(element);
		return nOffsetWindowTop;
	}
}

CCSSP.GetObjectHeight = function(obj)
{// retrieve the height of a posionable object
	if( CCSSP.bIsNav4 )
		return obj.clip.height;
	else
		return obj.offsetHeight;
}

CCSSP.GetObjectWidth = function(obj)
{// retrieve the width of a posionable object
	if( CCSSP.bIsNav4 )
		return obj.clip.width;
	else
		return obj.offsetWidth;
}

CCSSP.RegisterEventHandler = function( srcObj, rawEventName, funcHandler )
{ // to add the "funcHandler" as the "rawEventName" 's handler to the "srcObj" object,the original event handler will be combined
	var oldHandler = "";
	var oldInlineHandler = srcObj[rawEventName.toLowerCase()];
	if( oldInlineHandler != null )
	{
		var functionDefinition = oldInlineHandler.toString();
		var bodyStart = functionDefinition.indexOf( "{" );
		var bodyEnd = functionDefinition.lastIndexOf( "}" );
		if( bodyStart > 0 || bodyEnd > bodyStart )
			oldHandler = functionDefinition.substr( bodyStart + 1, bodyEnd - bodyStart - 2 );
	}
	else if( CCSSP.bIsIE4 )
	{ //search for <SCRIPT> tag which define the event handler
		for( var i = 0; i < document.scripts.length; i++ ) 
		{
			var script = document.scripts[i];
			if( (script.htmlFor == srcObj.id || script.htmlFor == srcObj ) && script.event == rawEventName )
			{
				oldHandler = script.innerHTML;
				break;
			}
		}
	}
	
	if( oldHandler.indexOf(funcHandler) >= 0 )
		return;// to prevent register the funtion twice.

	if( CCSSP.bIsNav4 ) // only "onload, onresize, onfocus" apply to window
	{// other raw events will apply to layer
		var noOn = rawEventName.substring(2, rawEventName.length);
		if( typeof(noOn) == "string" && noOn.length > 3 )
			srcObj.captureEvents( Event[noOn.toUpperCase()] );
	}

	var newHandler = oldHandler;
	if( newHandler.length == 0 )
		newHandler = funcHandler;
	else
		newHandler += "; " + funcHandler;
	srcObj[rawEventName.toLowerCase()] = new Function( newHandler );
}

CCSSP.GetWindowHeight = function()
{// retrieve the height of available content in browser window
	if( CCSSP.bIsNav4 )
		return window.innerHeight;
	else
		return document.body.clientHeight;
}

CCSSP.GetWindowBottom = function()
{// retrieve the bottom postion of browser window
	if( CCSSP.bIsNav4 )
		return window.outerHeight + window.pageYOffset;
	else
		return document.body.clientHeight + document.body.scrollTop;
}

CCSSP.GetWindowWidth = function()
{// retrieve the width of available content in browser window
	if( CCSSP.bIsNav4 )
		return window.innerWidth;
	else
		return document.body.clientWidth;
}

CCSSP.GetWindowRight = function()
{// retrieve the right postion of browser window
	if( CCSSP.bIsNav4 )
		return window.outerWidth + window.pageXOffset;
	else
		return document.body.clientWidth + document.body.scrollLeft;
}

CCSSP.TrimString = function( objString, subtrim )
{// to trim the "subtrim" in the beginning and ending of a string object
	if( typeof(subtrim) != "string" || subtrim == null )
		return objString;
	var strHead = objString.substring(0, 1);
	var strRear = objString.substring(objString.length-1, objString.length);
	if( strHead != subtrim && strRear != subtrim )
		return objString;
	
	var spacePos = objString.indexOf(subtrim);
	if( spacePos < 0 )
		return objString;
	else if( spacePos == objString.length - 1 )
		return objString.substring(0, spacePos);
	else
	{
		var newString = objString.substring( spacePos + 1, objString.length);
		return CCSSP.TrimString( newString, subtrim );
	}
}

CCSSP.TrimSpace = function( objString )
{
	var Trim1 = CCSSP.TrimString( objString, " ");
	return CCSSP.TrimString( Trim1, "\'");
}

CCSSP.GetEventElement = function( navEventObject )
{// to get the element who fired the current event
	if( CCSSP.bIsNav4 )
		return navEventObject.target;
	else
		return event.srcElement;
}

CCSSP.PrepareFilter = function( Obj )
{//to prepare for making the filter work
	Obj.style.filter = "";
	if( Obj.style.width != "" || Obj.style.height != "" || Obj.style.position == "absolute" )
		return;
	Obj.style.height = CCSSP.GetObjectHeight(Obj);
}

CCSSP.IsDescendant = function( progenitor, progeny )
{
	if( typeof(progeny) == "undefined" || progeny == null )
		return false;
	else if( progeny == progenitor )
		return true; 
	else if( progeny.id == progenitor.id ) 
		return true; 
	else if( progeny.parentElement == progenitor.parentElement )
		return false;
	else
		return CCSSP.IsDescendant( progenitor, progeny.parentElement );
}

CCSSP.IsTextTag = function( Obj )
{
	if( typeof( Obj.tagName ) == "undefined" )
		return false;
	return( Obj.tagName.indexOf("H") == 0 || Obj.tagName == "P" || 
			Obj.tagName == "FONT" || Obj.tagName == "SPAN" );
}

//End JavaScript libary for cross-platform positioning object.

/// Section End  - CCSSP DHTM (JavaScript 1.2)

/// Section Begin  - CCSSP DHTM 1 (JavaScript 1.2)

//Begin the definition of class CTrigger
function CTrigger( TriggerElement )
{
	// object : the trigger element. Never be null. 
	this.eleTrigger = TriggerElement;
	
	// number : the click counter number: only 3 values: 0,1,2;
	this.nCounter = 0; 
	
	//object as associative array of string:
	// the associate target ID strings; one element at least.			
	this.objStrTarget = new Object();
	this.eleTrigger.style.cursor = "hand";
	if( this.eleTrigger.tagName == "AREA" && this.eleTrigger.getAttribute("href") == "" )
		this.eleTrigger.setAttribute("href", "#") // to make a hand cursor for image map
}

CTrigger.prototype.AddTargetID = function( strTargetID )
{// add one target ID string to the objStrTarget
	if( typeof(strTargetID) != "string" )
		return ;
	if( typeof(this.objStrTarget[strTargetID]) != "string" )
		this.objStrTarget[strTargetID] = strTargetID;
}

CTrigger.prototype.OnTriggerClick = function()
{// to activate all asociated target
	var strEventType = ( (this.nCounter++)% 2 == 0 ) ? 
		"bssctrigger1" : "bssctrigger2";
		
	// to enumerate associative target element's ID string
	for( var strTargetID in this.objStrTarget ) 
		CEngine.SendEventToOneTarget( strTargetID, strEventType );
}
//End the definition of class CTrigger

//Begin the definition of class CTarget
function CTarget( TargetElement )
{
	// object : the target element. Never be null.
	this.eleTarget = TargetElement;
	this.objManager = new Object(); // object: the event manager
} 

CTarget.nPageClickCounter = 0;// static class property.

CTarget.prototype.GetAgencyObject = function(str_action_type,action_setting )
{// return the action agency ( effect )object's refernece 
	switch( str_action_type )
	{
	case "show":return new CAgencyShow( this.eleTarget, true ) ;
	case "hide":return new CAgencyShow( this.eleTarget, false ) ;

    case "flyin" : 
    	return new CAgencyFly(this.eleTarget, action_setting, true);
    case "flyout" : 
    	return new CAgencyFly(this.eleTarget, action_setting, false);
    case "spiralin" : 
    	return new CAgencySpiral(this.eleTarget, action_setting, true);
    case "spiralout" : 
    	return new CAgencySpiral(this.eleTarget, action_setting, false);
    case "zoomin" :
    	return new CAgencyZoom(this.eleTarget, action_setting, true);
    case "zoomout" : 
    	return new CAgencyZoom(this.eleTarget, action_setting, false);
    case "elastic" : 
		return new CAgencyElastic(this.eleTarget, action_setting);
		
    case "fadein" : 
    	return (CCSSP.bIsIE4)? new CAgencyAlpha(this.eleTarget, action_setting, true) : null;
    case "fadeout" :
    	return (CCSSP.bIsIE4)? new CAgencyAlpha(this.eleTarget, action_setting, false) : null;
    case "rockrollstatic" :
    case "rockroll" :
    	return (CCSSP.bIsIE4)? new CAgencyWave(this.eleTarget, action_setting, false) : null;
 
    case "glow":
    	return (CCSSP.bIsIE4)? new CAgencyGlow(this.eleTarget,action_setting) : null;
    case "dropshadow":
    	return (CCSSP.bIsIE4)? new CAgencyDropShadow(this.eleTarget,action_setting) : null;
    case "transition" :
    	return (CCSSP.bIsIE4)? new CAgencyRevealTrans(this.eleTarget,action_setting) : null;
    case "blur" :
    	return (CCSSP.bIsIE4)? new CAgencyBlur(this.eleTarget,action_setting) : null;

    case "fliph" : // all these 4 do NOT need any parameters
    case "flipv" :
    case "invert":
    case "gray" :
    	return (CCSSP.bIsIE4)? new CAgencyChangeFilter(this.eleTarget, str_action_type) : null;
    
    case "fontchange": // the effects below change the style on the fly, so won't work in Navigator
    	return (CCSSP.bIsIE4)? new CAgencyFontChange(this.eleTarget,action_setting) : null;
    case "boderchange": 
    case "stylechange":
    	return (CCSSP.bIsIE4)? new CAgencyChangeStyle(this.eleTarget,action_setting) : null;

	default: return null;
	}
}

CTarget.prototype.SetEventManager = function( 
	one_event_type,str_action_type,action_setting,event_additional)
{// to set the event manager with specified action 
	if( typeof( one_event_type ) != "string" ||	
		typeof( str_action_type ) != "string"||
		typeof( action_setting ) != "string" )
		return false;
	if( typeof(this.objManager[one_event_type]) == "undefined" )
	{
		this.objManager[one_event_type] = new Object();
		this.objManager[one_event_type].length = 0;
	}
	
	var eventAgency = this.GetAgencyObject(str_action_type,action_setting);
	if( eventAgency != null )
	{
		var ct = this.objManager[one_event_type].length ++;
		this.objManager[one_event_type][ct] = eventAgency;
		
		if( one_event_type == "bsscpageclick" )
		{// to deal with the "number of pageclick" stuff
			if( typeof(event_additional) == "number" )
				this.objManager[one_event_type][ct].nPageClick = event_additional;
			else // set the default number 
				this.objManager[one_event_type][ct].nPageClick = 1;
			
			if( (typeof(this.objManager.nMinPageClickIndex) == "undefined") ||
			    (this.objManager[one_event_type][ct].nPageClick < 
					this.objManager[one_event_type][this.objManager.nMinPageClickIndex].nPageClick) )
				this.objManager.nMinPageClickIndex = ct;
		}
		
		//hide the object blindly,SetState function will take care of the final correct state
		if( ((one_event_type == "bsscpageclick") && 
			 (this.objManager[one_event_type][ct].nPageClick == 1)) ||
			one_event_type == "bsscpageload" ||
			one_event_type == "bssctrigger1" )
			CCSSP.ShowObject( this.eleTarget, false );
		
		if( one_event_type == "bssctrigger1" || one_event_type == "bssctrigger2" )
			if( typeof( this.strTriggerEvent ) == "undefined" )
				this.strTriggerEvent = ( one_event_type == "bssctrigger1" ) ? "bssctrigger2" : "bssctrigger1";
			
		return true;
	}
	return false;
}

CTarget.prototype.OnEvent = function( strBsscEvent )
{// response to the event ( bssc format )
	if( typeof(this.objManager[strBsscEvent]) == "object" )
	{ // to get the event agency from the event manager
		var eventAgency = this.objManager[strBsscEvent];
		for( var i = 0; i < eventAgency.length; i++ )
		{
			if( strBsscEvent == "bsscpageclick" && 
			 	eventAgency[i].nPageClick != CTarget.nPageClickCounter )
				 continue;
			else if( strBsscEvent == "bsschover" && event.type == "mouseout" )
				eventAgency[i].EndEffect();
			else // to invoke the unified function in effect object	
				eventAgency[i].UpdateEffect(); 
		}
	}
}

CTarget.prototype.SetState = function( strBsscEvent )
{
	if( typeof(this.objManager[strBsscEvent]) != "object" )
		return false;

	// to get the event agency from the event manager
	var eventAgency = this.objManager[strBsscEvent];
	
	if( strBsscEvent == "bsscpageclick" )
	{// we only set the initial state for the minium number of pageclick 
		eventAgency[this.objManager.nMinPageClickIndex].PrepareEffect();
		return true;
	}
	else
	{
		for( var i = 0; i < eventAgency.length; i++ )
			eventAgency[i].PrepareEffect(); // to invoke the unified function in effect object	 
		if( i > 0 )
			return true;
		else
			return false;
	}
}
//End the definition of class CTarget

//Begin the definition of CEngine class
function CEngine(){}// all properities are going be "class" properities

// object : as associative array of trigger objects
CEngine.objTrigger = new Object();
// object : as associative array of target objects 
CEngine.objTarget = new Object(); 

// Array : each element is a CAgencyXXX animation object
CEngine.arrAnimation = new Array();
CEngine.PerformAnimation = function( nIndex )
{// animation : update effects function
	CEngine.arrAnimation[nIndex].UpdateEffect();
}

CEngine.AddOneTrigger = function(TriggerID,TriggerElement)
{// add one Trigger object into the trigger array
	if( typeof(TriggerID) != "string" || TriggerElement == null ||
	    typeof(TriggerElement) != "object" )
		return;
	if( typeof(CEngine.objTrigger[TriggerID] ) != "object" )
		CEngine.objTrigger[TriggerID] = new CTrigger(TriggerElement);
}
	
CEngine.AddOneTarget = function(TargetID, TargetElement)
{// add one Target object into the target array
	if( typeof(TargetID) != "string" || TargetElement == null ||
		typeof(TargetElement) != "object" )
		return;
	if( typeof(CEngine.objTarget[TargetID]) != "object" )
		CEngine.objTarget[TargetID] = new CTarget( TargetElement );
}

CEngine.SendEventToOneTarget = function(strTargetID, strBsscEvent )
{// to activate one target object
	if( typeof(CEngine.objTarget[strTargetID]) == "object" ) 
	{
		if( strBsscEvent == "bssctrigger1" || strBsscEvent == "bssctrigger2" )
		{//now, the "bssctrigger1" and "bssctrigger2" work like a toggle
			if( strBsscEvent == CEngine.objTarget[strTargetID].strTriggerEvent )
				strBsscEvent = (strBsscEvent == "bssctrigger1") ? "bssctrigger2" : "bssctrigger1";
			CEngine.objTarget[strTargetID].strTriggerEvent = strBsscEvent;
		}
		CEngine.objTarget[strTargetID].OnEvent( strBsscEvent );
	}
}

CEngine.SendEventToAllTarget = function( strBsscEvent )
{ //to activate all target associative to the BSSC event
	for( var strTargetID in CEngine.objTarget ) //to enumerate all target
		CEngine.SendEventToOneTarget( strTargetID, strBsscEvent );
}

CEngine.SetOneTargetInitialState = function( strTargetID )
{// only invoked after ALL effects for the target have been set
	if( typeof(CEngine.objTarget[strTargetID]) == "object" ) 
	{// to get target object
		var objTarget = CEngine.objTarget[strTargetID];
		if( objTarget.SetState( "bsscpageload" ) == false )
		{
			objTarget.SetState( "bsscpageclick" );
			objTarget.SetState( "bssctrigger1" );
		}
	}
}

CEngine.AdjustPageClickCounter = function()
{
	var nAdjustedClickCounter = CTarget.nPageClickCounter;
	var bAdjusted = false;
	for( var strTargetID in CEngine.objTarget ) //to enumerate all target
	{// try to find the minum pageCliclConter greater than CTarget.nPageClickCounter
		var objEventPageClick = CEngine.objTarget[strTargetID].objManager.bsscpageclick;
		if( objEventPageClick != null )
		{
			for( var i = 0; i < objEventPageClick.length; i++ )
			{
				var nOtherPageClick = objEventPageClick[i].nPageClick;
				if( nOtherPageClick == CTarget.nPageClickCounter )
					return;
				if( nOtherPageClick > CTarget.nPageClickCounter )
				{
					if( !bAdjusted )
					{
						nAdjustedClickCounter = nOtherPageClick;
						bAdjusted = true;
					}
					else if( nOtherPageClick < nAdjustedClickCounter )
						nAdjustedClickCounter = nOtherPageClick;
				}
			}
		}
	}
	CTarget.nPageClickCounter = nAdjustedClickCounter;
}

CEngine.OnPageLoad = function()
{ 	
	// first, to set all target's initial state
	for( var strTargetID in CEngine.objTarget )
		CEngine.SetOneTargetInitialState( strTargetID );
	
	// to invoke all target's onpageload handler
	CEngine.SendEventToAllTarget( "bsscpageload" );
}

CEngine.OnPageClick = function()
{ // to invoke all target's onpageclick handler
	var src = CCSSP.GetEventElement( arguments[0] );
	if( src == null )
		return;
		
	var objClickedTrigger = null;
	for( var strTriggerID in CEngine.objTrigger )
	{ // to detect which trigger is clicked
		if( CCSSP.IsDescendant( CEngine.objTrigger[strTriggerID].eleTrigger,src) )
		{
			objClickedTrigger = CEngine.objTrigger[strTriggerID];
			break;
		}
	}
	
	if( objClickedTrigger != null) // the clicked trigger found
		objClickedTrigger.OnTriggerClick();
	else // no trigger is clicked
	{ // to send PageClick event to all target
		CTarget.nPageClickCounter++;
		CEngine.AdjustPageClickCounter();
		CEngine.SendEventToAllTarget( "bsscpageclick" );
	}
}	

CEngine.OnMouseOver = function()
{ // to invoke all target's onpageload handler
	var src = CCSSP.GetEventElement( arguments[0] );
	if( src == null )
		return;
		
	var strHoveredTargetID = null;
	for( var strTargetID in CEngine.objTarget )
	{ // to detect which Target is hovering on
		if( CCSSP.IsDescendant( CEngine.objTarget[strTargetID].eleTarget, src ) )
	    {
			strHoveredTargetID = strTargetID;
			break;
	    }
	}
	
	if( strHoveredTargetID != null ) // the hovered target found
		CEngine.SendEventToOneTarget( strHoveredTargetID, "bsschover" );
}

CEngine.BuildTargetObject = function(target_ID,event_type,action_type,
			action_setting, event_additional)
{// to build target object 
	// to get the target object
	if( typeof( CEngine.objTarget[target_ID] ) != "object" )
		return false;// the engine's AddOneTarget function might have failed.
	var TargetObject = CEngine.objTarget[target_ID];
	
	// to prepare the parameters for the event manager
	var arrEvent = event_type.split("|"); // to split the combined event_type string
	var arrAction = action_type.split("|");//to split the combined action_type string
	for( var trim = 0; trim < arrEvent.length; trim++ )
		arrEvent[trim] = CCSSP.TrimSpace(arrEvent[trim]);
	
	for( trim = 0; trim < arrAction.length; trim++ )
		arrAction[trim] = CCSSP.TrimSpace(arrAction[trim]);
	
	var arrSetting = new Array(); 
	if( typeof(action_setting) == "string" )
		arrSetting = action_setting.split("|");// to split the combined action_setting string
	// to calibrate the arrays
	for( var i = arrSetting.length; i < arrAction.length; i++ )
	{
		if( typeof(arrSetting[i]) != "string" )
			 arrSetting[i] = "";
	}				 

	// to prepare for dealing with the absolute posioning element
	TargetObject.eleTarget.ABSX = CCSSP.GetObjectLeft( TargetObject.eleTarget );
	TargetObject.eleTarget.ABSY = CCSSP.GetObjectTop( TargetObject.eleTarget );

	if( arrEvent.length > 1 )
	{// if event is combined, it must be : "bssctrigger1 | bssctrigger2"
		if( arrAction.length != 2 )
			return false; // if event is combined, there must be 2 actions
		for( i = 0 ; i < 2; i++ )
		{
			if( TargetObject.SetEventManager(arrEvent[i], arrAction[i], 
				arrSetting[i], event_additional) == false )
				return false; // the event manager has not been set up
		}
	}
	else // the event_type string is not combined
	{
		for( i = 0 ; i < arrAction.length; i++ )
		{
			TargetObject.SetEventManager(event_type, arrAction[i], arrSetting[i], event_additional);
			// to validate the event manager
			if( typeof(TargetObject.objManager[event_type]) != "object" ||
					typeof(TargetObject.objManager[event_type][i]) != "object" )
				return false; // the event manager has not been set up
		}
	}
	return true;
}

CEngine.BuildTriggerObject = function(trigger_ID, target_ID)
{// to build the trigger object
	var arrTrigger = trigger_ID.split("|"); // to split the combined trigger_ID string
	for( var i = 0; i < arrTrigger.length; i ++ )
	{// to get the trigger element then add it to the trigger list
		arrTrigger[i] = CCSSP.TrimSpace( arrTrigger[i] );
		var eleTrigger = CCSSP.GetObject( arrTrigger[i] );
		if( eleTrigger == null )
			continue; // the trigger_ID string in the HTML code maybe wrong
		CEngine.AddOneTrigger( arrTrigger[i], eleTrigger );

		// to get the target object
		if( typeof( this.objTrigger[arrTrigger[i]] ) != "object" )
			continue;// the engine's AddOneTarget function might have failed.
		CEngine.objTrigger[arrTrigger[i]].AddTargetID( target_ID );
	}
}
//End the definition of CEngine class

/// Section End  - CCSSP DHTM 1 (JavaScript 1.2)

/// Section Begin  - CCSSP DHTM 2 (JavaScript 1.2)

//Begin the definition of CAgencyXXXX classes

//Begin of the CAgencyShow definition
function CAgencyShow( element, bIsShow )
{
	this.ele = element;
	this.bIsShow = bIsShow;
}

CAgencyShow.prototype.PrepareEffect = function()
{
	CCSSP.ShowObject( this.ele, !this.bIsShow );
}

CAgencyShow.prototype.UpdateEffect = function()
{
	CCSSP.ShowObject( this.ele, this.bIsShow );
}

CAgencyShow.prototype.EndEffect = function()
{
	CCSSP.ShowObject( this.ele, !this.bIsShow );
}
// End of the CAgencyShow definition

// Begin of CAgencyFly definition
function CAgencyFly( element, settings, bIsIn )
{
	this.ele = element;
	this.bIsIn = bIsIn;
	this.duration = 1000; // default
	this.direction = "right";

	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "speed" : this.duration = 100000/arrOneSet[1]; break;
		case "direction" : this.direction = arrOneSet[1]; break;
		}
	}
		
	if( CCSSP.bIsIE5 && this.ele.style.position != "absolute" )
		this.ele.style.position = "relative";
	this.timer = null;
	this.aniIndex = CEngine.arrAnimation.length;
	CEngine.arrAnimation[this.aniIndex] = this;
}

CAgencyFly.prototype.PrepareEffect = function()
{
	CCSSP.ShowObject(this.ele, !this.bIsIn );
}

CAgencyFly.prototype.UpdateEffect = function()
{
	if( this.timer == null )
		this.ResetParameters();

	var percent = ((new Date()).getTime() - this.startTime)/this.duration;
	if( percent >= 1.0 )
		this.EndEffect();
	else
	{
		var newX = this.startX*(1.0-percent) +  this.finalX*percent;
		var newY = this.startY*(1.0-percent) +  this.finalY*percent;
		CCSSP.MoveObjectTo(this.ele, newX, newY);
		if( this.timer == null )
			this.timer = setInterval("CEngine.PerformAnimation(" + this.aniIndex + ")", 20 );
	}
}

CAgencyFly.prototype.EndEffect = function()
{
	clearInterval( this.timer );
	this.timer = null;

	if( this.bIsIn ) // FlyIn
		CCSSP.MoveObjectTo(this.ele, this.finalX, this.finalY);
	else // FlyOut
		CCSSP.MoveObjectTo(this.ele, this.startX, this.startY);
	CCSSP.ShowObject(this.ele, this.bIsIn );
}

CAgencyFly.prototype.ResetParameters = function()
{
	this.PrepareEffect();
	CCSSP.ShowObject(this.ele, true );

	this.startX = 0;
	this.startY = 0;
	this.finalX = 0;
	this.finalY = 0; 
	
	var offsetLeft = CCSSP.GetObjectWindowLeft(this.ele) + this.ele.offsetWidth;
	var offsetTop = CCSSP.GetObjectWindowTop(this.ele) + this.ele.offsetHeight;
	var offsetRight = CCSSP.GetWindowRight();
	var offsetBottom = CCSSP.GetWindowBottom();

	if( this.bIsIn )
	{ // FlyIn
		this.finalX = this.ele.ABSX;
		this.finalY = this.ele.ABSY;

		switch( this.direction )
		{
		case "right": this.startX = offsetRight; this.startY = this.finalY; break;
		case "left": this.startX = -offsetLeft;  this.startY = this.finalY; break;
		case "down": this.startY = offsetBottom; this.startX = this.finalX; break;
		case "up":  this.startY = -offsetTop;    this.startX = this.finalX; break;
		case "downright":
  			this.startX = ( offsetBottom < offsetRight) ? offsetBottom : offsetRight;
			this.startY = this.startX;		break;
		case "upright":
  			this.startX = (offsetTop < offsetRight)? offsetTop : offsetRight;
			this.startY = -this.startX;		break;
		case "upleft":
			this.startX = -((offsetTop < offsetRight)? offsetTop : offsetRight);
			this.startY = this.startX;		break;
		case "downleft":
			this.startX = -(( offsetBottom < offsetRight) ? offsetBottom : offsetRight);
			this.startY = -this.startX;     break;
		}
	}
	else
	{ // FlyOut
		this.startX = this.ele.ABSX;
		this.startY = this.ele.ABSY;

		switch( this.direction )
		{
		case "right": this.finalX = offsetRight;  this.finalY = this.startY; break;
		case "left": this.finalX = -offsetLeft;   this.finalY = this.startY;  break;
		case "down": this.finalY = offsetBottom;  this.finalX = this.startX; break;
		case "up":  this.finalY = -offsetTop;     this.finalX = this.startX; break;
		case "downright":
  			this.finalX = ( offsetBottom < offsetRight) ? offsetBottom : offsetRight;
			this.finalY = this.finalX;		break;
		case "upright":
  			this.finalX = (offsetTop < offsetRight)? offsetTop : offsetRight;
			this.finalY = -this.finalX;		break;
		case "upleft":
			this.finalX = -((offsetTop < offsetRight)? offsetTop : offsetRight);
			this.finalY = this.finalX;		break;
		case "downleft":
			this.finalX = -(( offsetBottom < offsetRight) ? offsetBottom : offsetRight);
			this.finalY = -this.finalX;     break;
		}
	}
	CCSSP.MoveObjectTo(this.ele, this.startX, this.startY);
	this.startTime = (new Date()).getTime();
}
// End of the CAgencyFly definition

// Begin of CAgencySpiral
function CAgencySpiral( element, settings, bIsIn )
{
	this.ele = element;
	this.bIsIn = bIsIn;
	this.duration = 1000; // default

	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "speed" : this.duration = 100000/arrOneSet[1]; break;
		}
	}

	if( CCSSP.bIsIE5 && this.ele.style.position != "absolute" )
		this.ele.style.position = "relative";
	this.timer = null;
	this.aniIndex = CEngine.arrAnimation.length;
	CEngine.arrAnimation[this.aniIndex] = this;
}

CAgencySpiral.prototype.PrepareEffect = function()
{
	CCSSP.ShowObject(this.ele, !this.bIsIn );
}

CAgencySpiral.prototype.UpdateEffect = function()
{
	if( this.timer == null )
		this.ResetParameters();

	var percent = ((new Date()).getTime() - this.startTime)/this.duration;
	if( percent >= 1.0 )
		this.EndEffect();
	else
	{
		var rf = (this.bIsIn)? (1.0 - percent) : percent; 
		var t = (1.0-rf) * 4.0 * Math.PI
		var rxP = (this.bIsIn)? this.startX : this.finalX; 
		var ryP = (this.bIsIn)? this.startY : this.finalY; 
		var rx = (Math.abs(rxP) < 200) ? Math.abs(rxP) : 200;
		var ry = (Math.abs(ryP) < 200) ? Math.abs(ryP) : 200;

		var newX = Math.ceil(-rf*Math.cos(t)*rx) + this.ele.ABSX;
		var newY = Math.ceil(-rf*Math.sin(t)*ry) + this.ele.ABSY;
		CCSSP.MoveObjectTo(this.ele, newX, newY);
		if( this.timer == null )
			this.timer = setInterval("CEngine.PerformAnimation(" + this.aniIndex + ")", 20 );
	}
}

CAgencySpiral.prototype.EndEffect = function()
{
	clearInterval( this.timer );
	this.timer = null;
	
	if( this.bIsIn ) // In
		CCSSP.MoveObjectTo(this.ele, this.finalX, this.finalY);
	else // Out
		CCSSP.MoveObjectTo(this.ele, this.startX, this.startY);
	CCSSP.ShowObject(this.ele, this.bIsIn );
}

CAgencySpiral.prototype.ResetParameters = function()
{
	this.PrepareEffect();
	CCSSP.ShowObject(this.ele, true );
	this.startX = (this.bIsIn)? CCSSP.GetWindowRight() : this.ele.ABSX;
	this.startY = (this.bIsIn)? CCSSP.GetWindowBottom() : this.ele.ABSY;
	this.finalX = (this.bIsIn)? this.ele.ABSX : CCSSP.GetWindowRight();
	this.finalY = (this.bIsIn)? this.ele.ABSY : CCSSP.GetWindowBottom(); 
	
	CCSSP.MoveObjectTo(this.ele, this.startX, this.startY);
	this.startTime = (new Date()).getTime();
}
// End of CAgencySpiral

// Begin of CAgencyElastic
function CAgencyElastic( element, settings)
{
	this.ele = element;
	this.duration = 1000; // default
	this.direction = "right";

	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "speed" : this.duration = 100000/arrOneSet[1]; break;
		case "direction" : this.direction = arrOneSet[1]; break;
		}
	}
		
	if( CCSSP.bIsIE5 && this.ele.style.position != "absolute" )
		this.ele.style.position = "relative";
	this.timer = null;
	this.aniIndex = CEngine.arrAnimation.length;
	CEngine.arrAnimation[this.aniIndex] = this;
}

CAgencyElastic.prototype.PrepareEffect = function()
{
	CCSSP.ShowObject(this.ele, false );
}

CAgencyElastic.prototype.UpdateEffect = function()
{
	if( this.timer == null )
		this.ResetParameters();

	var percent = ((new Date()).getTime() - this.startTime)/this.duration;
	if( percent >= 1.0 )
		this.EndEffect();
	else
	{
		var newX = this.startX;
		var newY = this.startY;
		var rf = Math.exp(-percent*3);
		var t = percent * 1.5 * Math.PI
		var rx = (Math.abs(this.startX) > Math.abs(this.startY)) ? this.startX : this.startY;
		switch (this.direction )
		{
		case "left":   
		case "right" : newX = rf*Math.cos(t)*rx + this.ele.ABSX; break;
		case "up":	   
		case "down" :  newY = rf*Math.cos(t)*rx + this.ele.ABSX; break;
		}
		CCSSP.MoveObjectTo(this.ele, newX, newY);
		if( this.timer == null )
			this.timer = setInterval("CEngine.PerformAnimation(" + this.aniIndex + ")", 20 );
	}
}

CAgencyElastic.prototype.EndEffect = function()
{
	CCSSP.MoveObjectTo(this.ele, this.finalX, this.finalY);
	clearInterval( this.timer );
	this.timer = null;
}

CAgencyElastic.prototype.ResetParameters = function()
{
	CCSSP.ShowObject(this.ele, true );
	this.startX = this.ele.ABSX;
	this.finalX = this.ele.ABSX;
	this.startY = this.ele.ABSY;
	this.finalY = this.ele.ABSY;
	
	switch (this.direction)
	{ 
	case "left":  this.startX = -this.ele.offsetWidth; break;
	case "right": this.startX = this.ele.offsetWidth;  break;
	case "up":    this.startY = -this.ele.offsetHeight;break;
	case "down":  this.startY = this.ele.offsetHeight; break;
	}
	CCSSP.MoveObjectTo(this.ele, this.startX, this.startY);
	this.startTime = (new Date()).getTime();
}
// End of CAgencyElastic

// Begin of CAgencyZoom
function CAgencyZoom( element, settings, bIsIn)
{
	this.ele = element;
	this.duration = 1000; // default
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "speed" : this.duration = 100000/arrOneSet[1]; break;
		}
	}

	this.bIsIn = bIsIn;
	this.timer = null;
	this.aniIndex = CEngine.arrAnimation.length;
	CEngine.arrAnimation[this.aniIndex] = this;
}

CAgencyZoom.prototype.PrepareEffect = function()
{
	CCSSP.ShowObject(this.ele, false);
}

CAgencyZoom.prototype.UpdateEffect = function()
{
	if( this.timer == null )
		this.ResetParameters();

	var percent = ((new Date()).getTime() - this.startTime)/this.duration;
	if( percent >= 1.0 )
		this.EndEffect();
	else
	{
		var nFactorIn = Math.ceil(50+50*percent);
		var nFactorOut = Math.ceil(100+200*(1-percent));
		var AlterFontsize = ((this.bIsIn)? nFactorIn : nFactorOut) + "%";
		var AlterFactor = ((this.bIsIn)? nFactorIn : nFactorOut) / 100;
		
		this.UpdateEffectAllChildren(this.ele, AlterFontsize, AlterFactor);
		for(var index = 0; index < this.ele.all.length; index++)
			this.UpdateEffectAllChildren(this.ele.all[index], AlterFontsize, AlterFactor);
			
		if( this.timer == null )
			this.timer = setInterval("CEngine.PerformAnimation(" + this.aniIndex + ")", 20 );
	}
}

CAgencyZoom.prototype.UpdateEffectAllChildren = function(child, FontSize, Factor)
{
	if( CCSSP.IsTextTag(child) )
		child.style.fontSize = FontSize;
	else
	{
		if( typeof(child.orgWidth) == "number" )
			child.style.width = Factor * child.orgWidth;
		if( typeof(child.orgHeight) == "number" )
			child.style.height = Factor * child.orgHeight;
	}
}

CAgencyZoom.prototype.EndEffect = function()
{
	this.EndEffectAllChildren(this.ele);
	for(var index = 0; index < this.ele.all.length; index++)
		this.EndEffectAllChildren(this.ele.all[index]);
	
	clearInterval( this.timer );
	this.timer = null;
}

CAgencyZoom.prototype.EndEffectAllChildren = function( child )
{	
	if( CCSSP.IsTextTag(child) )
		child.style.fontSize = child.orgFontSize;
	else
	{
		if( typeof(child.intactWidth) != "undefined" )
		{
			child.width = child.intactWidth;
			child.height = child.intactHeight;
		}
		else if( typeof(child.style.intactPixelWidth) != "undefined" )
		{
			child.style.pixelWidth = child.style.intactPixelWidth;
			child.style.pixelHeight = child.style.intactPixelHeight;
		}
	}
}

CAgencyZoom.prototype.ResetParameters = function()
{
	this.PrepareEffect();
	this.ResetParametersAllChildren( this.ele );
	for(var index = 0; index < this.ele.all.length; index++)
		this.ResetParametersAllChildren(this.ele.all[index]);
		
	this.startTime = (new Date()).getTime();
}

CAgencyZoom.prototype.ResetParametersAllChildren = function( child )
{
	CCSSP.ShowObject(child, true );
	if( (child.tagName == "DIV") && (child.parentElement.tagName == "TD") )
		child.width = "100%";// if the div is inside a cell of table, we need the this hack
	
	if( CCSSP.IsTextTag(child) )
		child.orgFontSize = child.style.fontSize;
	else
	{
		if( child.width > "" || child.height > "" )
		{
			child.orgWidth = child.intactWidth = child.width;
			child.orgHeight = child.intactHeight = child.height;
		}
		else if( ( typeof(child.orgWidth) != "number" ) && (typeof(child.orgHeight) != "number") )
		{
			child.orgWidth = child.style.intactPixelWidth = child.style.pixelWidth;
			child.orgHeight = child.style.intactPixelHeight = child.style.pixelHeight;
		}
	}
}
// End of CAgencyZoom

//// the following effects will use IE's exclusive "filter" function ////
// Begin of CAgencyAlpha definition
function CAgencyAlpha( element, settings, bIsIn )
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;
	this.bIsIn = bIsIn;

	// to set the default value
	this.startOpacity = (this.bIsIn) ? 0 : 100;
	this.endOpacity = (this.bIsIn) ? 100 : 0;
	
	this.duration = 1000; // default
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "speed" : this.duration = 100000/arrOneSet[1]; break;
		}
	}
	
	this.timer = null;
	this.aniIndex = CEngine.arrAnimation.length;
	CEngine.arrAnimation[this.aniIndex] = this;
}

CAgencyAlpha.prototype.PrepareEffect = function()
{// to set the visual filter function
	// the visual filter ONLY work when set by "Width and Height" or
	// absolute position for DIV, SPAN and normal tag ( such as p )
	// but, "absolute" cause the following elements overlap, so:
	CCSSP.PrepareFilter( this.ele );
	CCSSP.ShowObject(this.ele, !this.bIsIn );
}

CAgencyAlpha.prototype.UpdateEffect = function()
{// to set the visual filter function
	if( this.timer == null )
		this.ResetParameters();
	if( typeof(this.ele.filters.alpha) != "object" )
	{
		this.EndEffect();
		return;
	}

	var percent = ((new Date()).getTime() - this.startTime)/this.duration;
	if( percent >= 1.0 )
		this.EndEffect();
	else if( typeof(this.ele.filters.alpha) == "object" )
	{
		this.ele.filters.alpha.opacity = this.startOpacity*(1.0-percent) + this.endOpacity*percent;
		if( this.timer == null )
			this.timer = setInterval("CEngine.PerformAnimation(" + this.aniIndex + ")", 20 );
	}
}

CAgencyAlpha.prototype.EndEffect = function()
{// to remove the visual filter function
	clearInterval( this.timer );
	this.timer = null;
	this.ele.style.filter = "";
	CCSSP.ShowObject(this.ele, this.bIsIn );
}

CAgencyAlpha.prototype.ResetParameters = function()
{
	this.PrepareEffect();
	CCSSP.ShowObject(this.ele, true );
	this.ele.style.filter = "alpha(opacity=" + this.startOpacity + ")";
	this.startTime = (new Date()).getTime();
}
// End of the CAgencyAlpha definition

// Begin of CAgencyWave definition
function CAgencyWave( element, settings )
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;

	this.duration = 0; // default
	this.strength = 10;
	this.freq = 1;
	this.lightstrength = 1;
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "duration" : this.duration = 100000/arrOneSet[1]; break;
		case "strength" : this.strength = arrOneSet[1]; break;
		case "freq" : this.freq = arrOneSet[1]; break;
		case "lightstrength" : this.lightstrength = arrOneSet[1]; break;
		}
	}

	this.timer = null;
	this.aniIndex = CEngine.arrAnimation.length;
	CEngine.arrAnimation[this.aniIndex] = this;
}

CAgencyWave.prototype.PrepareEffect = function()
{// to set the visual filter function
	CCSSP.PrepareFilter(this.ele);

	CCSSP.ShowObject(this.ele, true );
}

CAgencyWave.prototype.UpdateEffect = function()
{// to set the visual filter function
	if( this.timer == null )
		this.ResetParameters();
	if( typeof(this.ele.filters.wave) != "object" )
	{
		this.EndEffect();
		return;
	}

	if( this.duration > 0 )
	{
		var percent = ((new Date()).getTime() - this.startTime)/this.duration;
		if( percent >= 1.0 )
		{
			this.EndEffect();
			return;
		}
	}
	
	this.ele.filters.wave.phase += 5;
	this.ele.filters.wave.phase %= 100;
	if( this.timer == null )
		this.timer = setInterval("CEngine.PerformAnimation(" + this.aniIndex + ")", 50 );
}

CAgencyWave.prototype.EndEffect = function()
{// to remove the visual filter function
	this.ele.style.filter = "";
	clearInterval( this.timer );
	this.timer = null;
}

CAgencyWave.prototype.ResetParameters = function()
{
	this.PrepareEffect();
	this.ele.style.filter = "wave(strength=" + this.strength + ",freq=" + 
	 this.freq +", lightstrength=" + this.lightstrength +",phase=0);";
	this.startTime = (new Date()).getTime();
}
// End of the CAgencyWave definition

// Begin of CAgencyGlow definition
function CAgencyGlow( element, settings )
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;

	// to set the default value
	this.glowColor = "green";
	this.glowStrength = "3";
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "color" : this.glowColor = arrOneSet[1]; break;
		case "strength" : this.glowStrength = arrOneSet[1]; break;
		}
	}
}

CAgencyGlow.prototype.PrepareEffect = function()
{
	CCSSP.PrepareFilter(this.ele);
	CCSSP.ShowObject(this.ele, true );
	if( this.ele.style.backgroundColor != "" )
	{//style.backgroundColor somehow stop the visual filter
		this.ele.intactBackgroundColor = this.ele.style.backgroundColor;
		this.ele.style.backgroundColor = "";
	}
}

CAgencyGlow.prototype.UpdateEffect = function()
{// to set the visual filter function
	this.PrepareEffect();
	this.ele.style.filter = "glow(Color=" + this.glowColor + ", Strength=" + 
		this.glowStrength + ", enabled=true" +")";
}

CAgencyGlow.prototype.EndEffect = function()
{// to remove the visual filter function
	this.ele.style.filter = "";
	if( typeof(this.ele.intactBackgroundColor) != "undefined" )
		this.ele.style.backgroundColor = this.ele.intactBackgroundColor;
}
// End of the CAgencyGlow definition

// Begin of CAgencyDropShadow definition
function CAgencyDropShadow( element, settings )
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;

	// to set the default value
	this.shadowColor = "black"; 
	this.shadowOffx = "1";
	this.shadowOffy = "1";
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "color" : this.shadowColor = arrOneSet[1]; break;
		case "offx" : this.shadowOffx = arrOneSet[1]; break;
		case "offy" : this.shadowOffy = arrOneSet[1]; break;
		}
	}
}

CAgencyDropShadow.prototype.PrepareEffect = function()
{
	CCSSP.PrepareFilter(this.ele);
	CCSSP.ShowObject(this.ele, true );
	
	if( this.ele.style.backgroundColor != "" )
	{//style.backgroundColor somehow stop the visual filter
		this.ele.intactBackgroundColor = this.ele.style.backgroundColor;
		this.ele.style.backgroundColor = "";
	}
}

CAgencyDropShadow.prototype.UpdateEffect = function()
{// to set the visual filter function
	this.PrepareEffect();
	this.ele.style.filter = "dropshadow(color=" + this.shadowColor + ", offx=" + 
		this.shadowOffx + ", offy=" + this.shadowOffy + ")";
}

CAgencyDropShadow.prototype.EndEffect = function()
{// to remove the visual filter function
	this.ele.style.filter = "";
	if( typeof(this.ele.intactBackgroundColor) != "undefined" )
		this.ele.style.backgroundColor = this.ele.intactBackgroundColor;
}
// End of the CAgencyDropShadow definition

// Begin of CAgencyRevealTrans definition
function CAgencyRevealTrans( element, settings )
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;

	// to set the default value
	this.duration = 1.0; //The value is specified in seconds.milliseconds format (0.0000).
	this.transition = 0;
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "type" : this.transition = arrOneSet[1]; break;
		case "duration" : this.duration = 100/arrOneSet[1];	break;
		}
	}
}

CAgencyRevealTrans.prototype.PrepareEffect = function()
{
	CCSSP.PrepareFilter(this.ele);
	CCSSP.ShowObject( this.ele, false);
}

CAgencyRevealTrans.prototype.UpdateEffect = function()
{// to set the visual filter function
	if( typeof( this.ele.filters.RevealTrans ) == "object" )
	{
		if( this.ele.filters.RevealTrans.status == 2 )
			this.ele.filters.RevealTrans.stop();  
	}

	this.PrepareEffect();
	
	this.ele.style.filter = "RevealTrans(duration=" + this.duration + 
		", transition=" + this.transition + ")";
	
    if( typeof( this.ele.filters.RevealTrans ) == "object" )
    {
		this.ele.filters.RevealTrans.apply();
		CCSSP.ShowObject( this.ele, true);
		this.ele.filters.RevealTrans.play();  
	}
	else
		CCSSP.ShowObject( this.ele, true);
}

CAgencyRevealTrans.prototype.EndEffect = function()
{
    if( typeof( this.ele.filters.RevealTrans ) == "object" )
		this.ele.filters.RevealTrans.stop();  
	this.ele.style.filter = "";
}
// End of the CAgencyRevealTrans definition

// Begin of CAgencyBlur definition
function CAgencyBlur( element, settings )
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;

	// to set the default value
	this.strength = "5";
	this.direction = "90";
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "strength" : this.strength = arrOneSet[1]; break;
		case "direction" : this.direction = arrOneSet[1]; break;
		}
	}
}

CAgencyBlur.prototype.PrepareEffect = function()
{
	CCSSP.PrepareFilter(this.ele);
	CCSSP.ShowObject(this.ele, true );
}

CAgencyBlur.prototype.UpdateEffect = function()
{// to set the visual filter function
	CCSSP.PrepareFilter(this.ele);
	this.ele.style.filter = "blur(strength=" + this.strength + 
		", direction=" + this.direction + ")";
}

CAgencyBlur.prototype.EndEffect = function()
{// to remove the visual filter function
	this.ele.style.filter = "";
}
// End of the CAgencyBlur definition

// Begin of CAgencyChangeFilter definition
function CAgencyChangeFilter( element, settings ) // flipH, flipV, invert, grey,
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;

	// to set the default value
	this.filterFunction = settings;
}

CAgencyChangeFilter.prototype.PrepareEffect = function()
{
	CCSSP.PrepareFilter(this.ele);
	CCSSP.ShowObject(this.ele, true );
}

CAgencyChangeFilter.prototype.UpdateEffect = function()
{// to set the visual filter function
	CCSSP.PrepareFilter(this.ele);
	this.ele.style.filter = this.filterFunction;
}

CAgencyChangeFilter.prototype.EndEffect = function()
{// to remove the visual filter function
	this.ele.style.filter = "";
}
// End of the CAgencyChangeFilter definition

// The effects below change the style on the fly, so they won't work in Navigator

// Begin of CAgencyFontChange definition, 
function CAgencyFontChange( element, settings )
{//this class can be replace by CAgencyChangeStyle,provided the "settings" is standard CSS string.
	this.ele = element;
	
	// to retrieve the original font style
	this.RetrieveOldFont( this.ele );
	
	// to set the default font to change
	this.newfontFamily = this.ele.oldFontFamily;
	this.newfColor = this.ele.oldColor;
	this.newtextDecoration = this.ele.oldTextDecoration;
	this.newfontWeight = this.ele.oldFontWeight;
	this.newfontStyle = this.ele.oldFontStyle;
	this.newfontSize = this.ele.oldFontSize;
	this.newBackgroundColor = this.ele.oldBackgroundColor;
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "font-family" : this.newfontFamily = arrOneSet[1]; break;
		case "color" : this.newfColor = arrOneSet[1]; break;
		case "underline" : this.newtextDecoration = (arrOneSet[1]=="on")? "underline" : "none"; break;
		case "bold" : this.newfontWeight = (arrOneSet[1]=="on")? "bold" : "normal"; break;
		case "italic" : this.newfontStyle = (arrOneSet[1]=="on")? "italic" : "normal"; break;
		case "size" : this.newfontSize = arrOneSet[1]; break;
		case "background-color" : this.newBackgroundColor = arrOneSet[1]; break;
		}
	}
}

CAgencyFontChange.prototype.RetrieveOldFont = function(objChild)
{
	if( typeof(objChild.oldFontFamily) == "undefined" )
		objChild.oldFontFamily = objChild.style.fontFamily;
	if( typeof(objChild.oldColor) == "undefined" )
		objChild.oldColor = objChild.style.color;
	if( typeof(objChild.oldTextDecoration) == "undefined" )
		objChild.oldTextDecoration = objChild.style.textDecoration;
	if( typeof(objChild.oldFontWeight) == "undefined" )
		objChild.oldFontWeight = objChild.style.fontWeight;
	if( typeof(objChild.oldFontStyle) == "undefined" )
		objChild.oldFontStyle = objChild.style.fontStyle;
	if( typeof(objChild.oldFontSize) == "undefined" )
		objChild.oldFontSize = objChild.style.fontSize;
	if( typeof(objChild.oldBackgroundColor) == "undefined" )
		objChild.oldBackgroundColor = objChild.style.backgroundColor;
}

CAgencyFontChange.prototype.PrepareEffect = function()
{
	// as for expanding text, the child is created after the constructor called
	for(var index = 0; index < this.ele.all.length; index++)
		this.RetrieveOldFont(this.ele.all[index]);
	CCSSP.ShowObject(this.ele, true );
}

CAgencyFontChange.prototype.UpdateEffect = function()
{// to change the font
	this.PrepareEffect();
	this.UpdateEffectAllChildren( this.ele );
	for( var index = 0; index < this.ele.all.length; index++)
		this.UpdateEffectAllChildren(this.ele.all[index]);
}

CAgencyFontChange.prototype.UpdateEffectAllChildren = function(objChild)
{
	objChild.style.fontFamily = this.newfontFamily;
	objChild.style.color = this.newfColor;
	objChild.style.textDecoration = this.newtextDecoration;
	objChild.style.fontWeight = this.newfontWeight;
	objChild.style.fontStyle = this.newfontStyle;
	objChild.style.fontSize = this.newfontSize;
	objChild.style.backgroundColor = this.newBackgroundColor;
}

CAgencyFontChange.prototype.EndEffect = function()
{// to reinstate the original font style
	this.EndEffectAllChildren( this.ele );
	for( var index = 0; index < this.ele.all.length; index++)
		this.EndEffectAllChildren(this.ele.all[index]);
}

CAgencyFontChange.prototype.EndEffectAllChildren = function( objChild )
{
	if( typeof(objChild.oldFontFamily) != "undefined" )
		objChild.style.fontFamily = objChild.oldFontFamily;
	if( typeof(objChild.oldColor) != "undefined" )
		objChild.style.color = objChild.oldColor;
	if( typeof(objChild.oldFontWeight) != "undefined" )
		objChild.style.fontWeight = objChild.oldFontWeight;
	if( typeof(objChild.oldFontStyle) != "undefined" )
		objChild.style.fontStyle = objChild.oldFontStyle;
	if( typeof(objChild.oldFontSize) != "undefined" )
		objChild.style.fontSize = objChild.oldFontSize;
	if( typeof(objChild.oldTextDecoration) != "undefined" )
		objChild.style.textDecoration = objChild.oldTextDecoration;
	if( typeof(objChild.oldBackgroundColor) != "undefined" )
		objChild.style.backgroundColor = objChild.oldBackgroundColor;
}
// End of the CAgencyFontChange definition

// Begin of the CAgencyChangeStyle definition
function CAgencyChangeStyle( element, settings )
{//this class can be replace by CAgencyChangeStyle,provided the "settings" is standard CSS string.
	this.ele = element;
	
	// to retrieve the original style
	this.oldstyle = this.ele.style.cssText;
	
	// to set the default style
	this.newStyle = this.oldstyle;
	
	if( typeof(settings) == "string" && settings.length > 1 )
		this.newStyle = this.oldstyle + " " + settings;
}

CAgencyChangeStyle.prototype.PrepareEffect = function()
{
	CCSSP.ShowObject(this.ele, true );
}

CAgencyChangeStyle.prototype.UpdateEffect = function()
{// to change the style
	this.ele.style.cssText = this.newStyle;
}

CAgencyChangeStyle.prototype.EndEffect = function()
{// to reinstate the original style
	this.ele.style.cssText = this.oldStyle;
}
// End of the CAgencyChangeStyle definition

//End the definition of CAgencyXXXX classes

//Begin to collaborate with other event handler settings 
CCSSP.RegisterEventHandler( window, "onload", "CEngine.OnPageLoad();BSSCOnLoad();kadovInitTriggersInHead();");
CCSSP.RegisterEventHandler( document, "onclick", "CEngine.OnPageClick();BSSCOnClick();");
CCSSP.RegisterEventHandler( document, "onmouseover", "CEngine.OnMouseOver();BSSCOnMouseOver();" );
CCSSP.RegisterEventHandler( document, "onmouseout", "CEngine.OnMouseOver();BSSCOnMouseOut();" );
CCSSP.RegisterEventHandler( window, "onunload", "BSSCOnUnload();");
//End to collaborate with other event handler settings


/// Section End  - CCSSP DHTM 2 (JavaScript 1.2)

//// Segment End -- (JavaScript 1.2)
